/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@JsonDeserialize(builder=CbsaWageIndexEntryBuilder.class)
@Immutable
public class CbsaWageIndexEntry {
    @Pattern(regexp="\\d{2}|\\d{5}", message="must be either two or five digits")
    private final @Pattern(regexp="\\d{2}|\\d{5}", message="must be either two or five digits") String cbsa;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
    private final LocalDate effectiveDate;
    @Digits(integer=2, fraction=4)
    private final @Digits(integer=2, fraction=4) BigDecimal geographicWageIndex;
    @Digits(integer=2, fraction=4)
    private final @Digits(integer=2, fraction=4) BigDecimal imputedFloorWageIndex;
    private final String name;
    @Digits(integer=2, fraction=4)
    private final @Digits(integer=2, fraction=4) BigDecimal reclassifiedWageIndex;
    @Digits(integer=2, fraction=4)
    private final @Digits(integer=2, fraction=4) BigDecimal ruralFloorWageIndex;
    @Pattern(regexp="^([A-Z]|)$")
    private final @Pattern(regexp="^([A-Z]|)$") String size;

    public CbsaWageIndexEntryBuilder copyBuilder() {
        return CbsaWageIndexEntry.builder().cbsa(this.getCbsa()).effectiveDate(this.getEffectiveDate()).geographicWageIndex(this.getGeographicWageIndex()).imputedFloorWageIndex(this.getImputedFloorWageIndex()).name(this.getName()).reclassifiedWageIndex(this.getReclassifiedWageIndex()).ruralFloorWageIndex(this.getRuralFloorWageIndex()).size(this.getSize());
    }

    @Generated
    CbsaWageIndexEntry(String cbsa, LocalDate effectiveDate, BigDecimal geographicWageIndex, BigDecimal imputedFloorWageIndex, String name, BigDecimal reclassifiedWageIndex, BigDecimal ruralFloorWageIndex, String size) {
        this.cbsa = cbsa;
        this.effectiveDate = effectiveDate;
        this.geographicWageIndex = geographicWageIndex;
        this.imputedFloorWageIndex = imputedFloorWageIndex;
        this.name = name;
        this.reclassifiedWageIndex = reclassifiedWageIndex;
        this.ruralFloorWageIndex = ruralFloorWageIndex;
        this.size = size;
    }

    @Generated
    public static CbsaWageIndexEntryBuilder builder() {
        return new CbsaWageIndexEntryBuilder();
    }

    @Generated
    public String getCbsa() {
        return this.cbsa;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getGeographicWageIndex() {
        return this.geographicWageIndex;
    }

    @Generated
    public BigDecimal getImputedFloorWageIndex() {
        return this.imputedFloorWageIndex;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BigDecimal getReclassifiedWageIndex() {
        return this.reclassifiedWageIndex;
    }

    @Generated
    public BigDecimal getRuralFloorWageIndex() {
        return this.ruralFloorWageIndex;
    }

    @Generated
    public String getSize() {
        return this.size;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class CbsaWageIndexEntryBuilder {
        @Generated
        private String cbsa;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private BigDecimal geographicWageIndex;
        @Generated
        private BigDecimal imputedFloorWageIndex;
        @Generated
        private String name;
        @Generated
        private BigDecimal reclassifiedWageIndex;
        @Generated
        private BigDecimal ruralFloorWageIndex;
        @Generated
        private String size;

        @Generated
        CbsaWageIndexEntryBuilder() {
        }

        @Generated
        public CbsaWageIndexEntryBuilder cbsa(String cbsa) {
            this.cbsa = cbsa;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd")
        @Generated
        public CbsaWageIndexEntryBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public CbsaWageIndexEntryBuilder geographicWageIndex(BigDecimal geographicWageIndex) {
            this.geographicWageIndex = geographicWageIndex;
            return this;
        }

        @Generated
        public CbsaWageIndexEntryBuilder imputedFloorWageIndex(BigDecimal imputedFloorWageIndex) {
            this.imputedFloorWageIndex = imputedFloorWageIndex;
            return this;
        }

        @Generated
        public CbsaWageIndexEntryBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public CbsaWageIndexEntryBuilder reclassifiedWageIndex(BigDecimal reclassifiedWageIndex) {
            this.reclassifiedWageIndex = reclassifiedWageIndex;
            return this;
        }

        @Generated
        public CbsaWageIndexEntryBuilder ruralFloorWageIndex(BigDecimal ruralFloorWageIndex) {
            this.ruralFloorWageIndex = ruralFloorWageIndex;
            return this;
        }

        @Generated
        public CbsaWageIndexEntryBuilder size(String size) {
            this.size = size;
            return this;
        }

        @Generated
        public CbsaWageIndexEntry build() {
            return new CbsaWageIndexEntry(this.cbsa, this.effectiveDate, this.geographicWageIndex, this.imputedFloorWageIndex, this.name, this.reclassifiedWageIndex, this.ruralFloorWageIndex, this.size);
        }

        @Generated
        public String toString() {
            return "CbsaWageIndexEntry.CbsaWageIndexEntryBuilder(cbsa=" + this.cbsa + ", effectiveDate=" + this.effectiveDate + ", geographicWageIndex=" + this.geographicWageIndex + ", imputedFloorWageIndex=" + this.imputedFloorWageIndex + ", name=" + this.name + ", reclassifiedWageIndex=" + this.reclassifiedWageIndex + ", ruralFloorWageIndex=" + this.ruralFloorWageIndex + ", size=" + this.size + ")";
        }
    }
}

