/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.NonTherapyAncillaryRateEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class NonTherapyAncillaryRateLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/nta-rates-%s.csv";
    private final CsvContentReader<NonTherapyAncillaryRateEntry> contentProvider = new CsvContentReader<NonTherapyAncillaryRateEntry>(NonTherapyAncillaryRateEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public NonTherapyAncillaryRateLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, Map<String, NonTherapyAncillaryRateEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, Map<String, NonTherapyAncillaryRateEntry>> generate(String csvFile) {
        List<NonTherapyAncillaryRateEntry> content = this.contentProvider.read(csvFile);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<NonTherapyAncillaryRateEntry, ?, Map> collector = Collectors.toMap(NonTherapyAncillaryRateEntry::getGroup, Function.identity(), comparator, HashMap::new);
        return LookupGenerator.generateCrossReferenceToMap(NonTherapyAncillaryRateEntry::getRegion, content, HashMap::new, collector);
    }
}

