/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@JsonDeserialize(builder=NursingRateEntryBuilder.class)
@JsonPropertyOrder(value={"region", "group", "rate", "aidsAdjustedRate", "qualityAdjustedRate", "aidsAndQualityAdjustedRate"})
@Immutable
public class NursingRateEntry {
    @Pattern(regexp="RURAL|URBAN", message="must be either RURAL or URBAN")
    private final @Pattern(regexp="RURAL|URBAN", message="must be either RURAL or URBAN") String region;
    @Pattern(regexp="[A-Y]", message="must be single letter A-Y")
    private final @Pattern(regexp="[A-Y]", message="must be single letter A-Y") String group;
    @Digits(integer=4, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="9999.99")
    private final @Digits(integer=4, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="9999.99") BigDecimal rate;
    @Digits(integer=4, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="9999.99")
    private final @Digits(integer=4, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="9999.99") BigDecimal aidsAdjustedRate;
    @Digits(integer=4, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="9999.99")
    private final @Digits(integer=4, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="9999.99") BigDecimal qualityAdjustedRate;
    @Digits(integer=4, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="9999.99")
    private final @Digits(integer=4, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="9999.99") BigDecimal aidsAndQualityAdjustedRate;

    public NursingRateEntryBuilder copyBuilder() {
        return NursingRateEntry.builder().region(this.getRegion()).group(this.getGroup()).rate(this.getRate()).aidsAdjustedRate(this.getAidsAdjustedRate()).qualityAdjustedRate(this.getQualityAdjustedRate()).aidsAndQualityAdjustedRate(this.getAidsAndQualityAdjustedRate());
    }

    @Generated
    NursingRateEntry(String region, String group, BigDecimal rate, BigDecimal aidsAdjustedRate, BigDecimal qualityAdjustedRate, BigDecimal aidsAndQualityAdjustedRate) {
        this.region = region;
        this.group = group;
        this.rate = rate;
        this.aidsAdjustedRate = aidsAdjustedRate;
        this.qualityAdjustedRate = qualityAdjustedRate;
        this.aidsAndQualityAdjustedRate = aidsAndQualityAdjustedRate;
    }

    @Generated
    public static NursingRateEntryBuilder builder() {
        return new NursingRateEntryBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NursingRateEntry)) {
            return false;
        }
        NursingRateEntry other = (NursingRateEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        BigDecimal this$rate = this.getRate();
        BigDecimal other$rate = other.getRate();
        if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
            return false;
        }
        BigDecimal this$aidsAdjustedRate = this.getAidsAdjustedRate();
        BigDecimal other$aidsAdjustedRate = other.getAidsAdjustedRate();
        if (this$aidsAdjustedRate == null ? other$aidsAdjustedRate != null : !((Object)this$aidsAdjustedRate).equals(other$aidsAdjustedRate)) {
            return false;
        }
        BigDecimal this$qualityAdjustedRate = this.getQualityAdjustedRate();
        BigDecimal other$qualityAdjustedRate = other.getQualityAdjustedRate();
        if (this$qualityAdjustedRate == null ? other$qualityAdjustedRate != null : !((Object)this$qualityAdjustedRate).equals(other$qualityAdjustedRate)) {
            return false;
        }
        BigDecimal this$aidsAndQualityAdjustedRate = this.getAidsAndQualityAdjustedRate();
        BigDecimal other$aidsAndQualityAdjustedRate = other.getAidsAndQualityAdjustedRate();
        return !(this$aidsAndQualityAdjustedRate == null ? other$aidsAndQualityAdjustedRate != null : !((Object)this$aidsAndQualityAdjustedRate).equals(other$aidsAndQualityAdjustedRate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NursingRateEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        BigDecimal $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        BigDecimal $aidsAdjustedRate = this.getAidsAdjustedRate();
        result = result * 59 + ($aidsAdjustedRate == null ? 43 : ((Object)$aidsAdjustedRate).hashCode());
        BigDecimal $qualityAdjustedRate = this.getQualityAdjustedRate();
        result = result * 59 + ($qualityAdjustedRate == null ? 43 : ((Object)$qualityAdjustedRate).hashCode());
        BigDecimal $aidsAndQualityAdjustedRate = this.getAidsAndQualityAdjustedRate();
        result = result * 59 + ($aidsAndQualityAdjustedRate == null ? 43 : ((Object)$aidsAndQualityAdjustedRate).hashCode());
        return result;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public BigDecimal getRate() {
        return this.rate;
    }

    @Generated
    public BigDecimal getAidsAdjustedRate() {
        return this.aidsAdjustedRate;
    }

    @Generated
    public BigDecimal getQualityAdjustedRate() {
        return this.qualityAdjustedRate;
    }

    @Generated
    public BigDecimal getAidsAndQualityAdjustedRate() {
        return this.aidsAndQualityAdjustedRate;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class NursingRateEntryBuilder {
        @Generated
        private String region;
        @Generated
        private String group;
        @Generated
        private BigDecimal rate;
        @Generated
        private BigDecimal aidsAdjustedRate;
        @Generated
        private BigDecimal qualityAdjustedRate;
        @Generated
        private BigDecimal aidsAndQualityAdjustedRate;

        @Generated
        NursingRateEntryBuilder() {
        }

        @Generated
        public NursingRateEntryBuilder region(String region) {
            this.region = region;
            return this;
        }

        @Generated
        public NursingRateEntryBuilder group(String group) {
            this.group = group;
            return this;
        }

        @Generated
        public NursingRateEntryBuilder rate(BigDecimal rate) {
            this.rate = rate;
            return this;
        }

        @Generated
        public NursingRateEntryBuilder aidsAdjustedRate(BigDecimal aidsAdjustedRate) {
            this.aidsAdjustedRate = aidsAdjustedRate;
            return this;
        }

        @Generated
        public NursingRateEntryBuilder qualityAdjustedRate(BigDecimal qualityAdjustedRate) {
            this.qualityAdjustedRate = qualityAdjustedRate;
            return this;
        }

        @Generated
        public NursingRateEntryBuilder aidsAndQualityAdjustedRate(BigDecimal aidsAndQualityAdjustedRate) {
            this.aidsAndQualityAdjustedRate = aidsAndQualityAdjustedRate;
            return this;
        }

        @Generated
        public NursingRateEntry build() {
            return new NursingRateEntry(this.region, this.group, this.rate, this.aidsAdjustedRate, this.qualityAdjustedRate, this.aidsAndQualityAdjustedRate);
        }

        @Generated
        public String toString() {
            return "NursingRateEntry.NursingRateEntryBuilder(region=" + this.region + ", group=" + this.group + ", rate=" + this.rate + ", aidsAdjustedRate=" + this.aidsAdjustedRate + ", qualityAdjustedRate=" + this.qualityAdjustedRate + ", aidsAndQualityAdjustedRate=" + this.aidsAndQualityAdjustedRate + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String REGION = "region";
        public static final String GROUP = "group";
        public static final String RATE = "rate";
        public static final String AIDS_ADJUSTED_RATE = "aidsAdjustedRate";
        public static final String QUALITY_ADJUSTED_RATE = "qualityAdjustedRate";
        public static final String AIDS_AND_QUALITY_ADJUSTED_RATE = "aidsAndQualityAdjustedRate";
    }
}

