/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.SpeechLanguagePathologyRateEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class SpeechLanguagePathologyRateLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/slp-rates-%s.csv";
    private final CsvContentReader<SpeechLanguagePathologyRateEntry> contentProvider = new CsvContentReader<SpeechLanguagePathologyRateEntry>(SpeechLanguagePathologyRateEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public SpeechLanguagePathologyRateLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, Map<String, SpeechLanguagePathologyRateEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, Map<String, SpeechLanguagePathologyRateEntry>> generate(String csvFile) {
        List<SpeechLanguagePathologyRateEntry> content = this.contentProvider.read(csvFile);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<SpeechLanguagePathologyRateEntry, ?, Map> collector = Collectors.toMap(SpeechLanguagePathologyRateEntry::getGroup, Function.identity(), comparator, HashMap::new);
        return LookupGenerator.generateCrossReferenceToMap(SpeechLanguagePathologyRateEntry::getRegion, content, HashMap::new, collector);
    }
}

