/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import com.codahale.metrics.InstrumentedScheduledExecutorService;
import com.codahale.metrics.InstrumentedThreadFactory;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.health.DelayedShutdownHandler;
import io.dropwizard.health.HealthCheckConfigValidator;
import io.dropwizard.health.HealthCheckConfiguration;
import io.dropwizard.health.HealthCheckManager;
import io.dropwizard.health.HealthCheckScheduler;
import io.dropwizard.health.HealthEnvironment;
import io.dropwizard.health.HealthFactory;
import io.dropwizard.health.response.HealthResponderFactory;
import io.dropwizard.health.response.HealthResponseProvider;
import io.dropwizard.health.response.HealthResponseProviderFactory;
import io.dropwizard.health.response.JsonHealthResponseProviderFactory;
import io.dropwizard.health.response.ServletHealthResponderFactory;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.util.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="default")
public class DefaultHealthFactory
implements HealthFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHealthFactory.class);
    private static final String DEFAULT_BASE_NAME = "health-check";
    private static final String DEFAULT_PATH = "/health-check";
    @JsonProperty
    private boolean enabled = true;
    @Valid
    @NotNull
    @JsonProperty
    private List<HealthCheckConfiguration> healthChecks = Collections.emptyList();
    @JsonProperty
    private boolean initialOverallState = true;
    @JsonProperty
    private boolean delayedShutdownHandlerEnabled = false;
    @NotNull
    @JsonProperty
    private Duration shutdownWaitPeriod = Duration.seconds(15L);
    @NotNull
    @Size(min=1)
    @JsonProperty
    private @NotNull @Size(min=1) List<String> healthCheckUrlPaths = Collections.singletonList("/health-check");
    @Valid
    @JsonProperty(value="responseProvider")
    private HealthResponseProviderFactory healthResponseProviderFactory = new JsonHealthResponseProviderFactory();
    @Valid
    @JsonProperty(value="responder")
    private HealthResponderFactory healthResponderFactory = new ServletHealthResponderFactory();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonProperty(value="healthChecks")
    public List<HealthCheckConfiguration> getHealthCheckConfigurations() {
        return this.healthChecks;
    }

    @JsonProperty(value="healthChecks")
    public void setHealthCheckConfigurations(List<HealthCheckConfiguration> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public boolean isInitialOverallState() {
        return this.initialOverallState;
    }

    public void setInitialOverallState(boolean initialOverallState) {
        this.initialOverallState = initialOverallState;
    }

    public boolean isDelayedShutdownHandlerEnabled() {
        return this.delayedShutdownHandlerEnabled;
    }

    public void setDelayedShutdownHandlerEnabled(boolean delayedShutdownHandlerEnabled) {
        this.delayedShutdownHandlerEnabled = delayedShutdownHandlerEnabled;
    }

    public Duration getShutdownWaitPeriod() {
        return this.shutdownWaitPeriod;
    }

    public void setShutdownWaitPeriod(Duration shutdownWaitPeriod) {
        this.shutdownWaitPeriod = shutdownWaitPeriod;
    }

    public List<String> getHealthCheckUrlPaths() {
        return this.healthCheckUrlPaths;
    }

    public void setHealthCheckUrlPaths(List<String> healthCheckUrlPaths) {
        this.healthCheckUrlPaths = healthCheckUrlPaths;
    }

    public HealthResponseProviderFactory getHealthResponseProviderFactory() {
        return this.healthResponseProviderFactory;
    }

    public void setHealthResponseProviderFactory(HealthResponseProviderFactory healthResponseProviderFactory) {
        this.healthResponseProviderFactory = healthResponseProviderFactory;
    }

    public HealthResponderFactory getHealthResponderFactory() {
        return this.healthResponderFactory;
    }

    public void setHealthResponderFactory(HealthResponderFactory healthResponderFactory) {
        this.healthResponderFactory = healthResponderFactory;
    }

    @Deprecated
    public List<HealthCheckConfiguration> getHealthChecks() {
        return this.healthChecks;
    }

    @Deprecated
    public void setHealthChecks(List<HealthCheckConfiguration> healthChecks) {
        this.healthChecks = healthChecks;
    }

    @Override
    public void configure(LifecycleEnvironment lifecycle, ServletEnvironment servlets, JerseyEnvironment jersey, HealthEnvironment health, ObjectMapper mapper, String name) {
        if (!this.isEnabled()) {
            LOGGER.info("Health check configuration is disabled.");
            return;
        }
        MetricRegistry metrics = lifecycle.getMetricRegistry();
        HealthCheckRegistry envHealthChecks = health.healthChecks();
        String fullName = "health-check-" + name;
        List<HealthCheckConfiguration> healthCheckConfigs = this.getHealthCheckConfigurations();
        ScheduledExecutorService scheduledHealthCheckExecutor = this.createScheduledExecutorForHealthChecks(healthCheckConfigs.size(), metrics, lifecycle, fullName);
        HealthCheckScheduler scheduler = new HealthCheckScheduler(scheduledHealthCheckExecutor);
        HealthCheckManager healthCheckManager = new HealthCheckManager(healthCheckConfigs, scheduler, metrics, this.shutdownWaitPeriod, this.initialOverallState, health.healthStateListeners());
        healthCheckManager.initializeAppHealth();
        HealthResponseProvider responseProvider = this.healthResponseProviderFactory.build(healthCheckManager, healthCheckManager, mapper);
        this.healthResponderFactory.configure(fullName, this.healthCheckUrlPaths, responseProvider, health, jersey, servlets, mapper);
        envHealthChecks.addListener(healthCheckManager);
        lifecycle.manage(new HealthCheckConfigValidator(healthCheckConfigs, envHealthChecks));
        Duration shutdownDelay = this.getShutdownWaitPeriod();
        if (this.isDelayedShutdownHandlerEnabled() && shutdownDelay.toMilliseconds() > 0L) {
            DelayedShutdownHandler shutdownHandler = new DelayedShutdownHandler(healthCheckManager);
            shutdownHandler.register();
            LOGGER.debug("Set up delayed shutdown with delay: {}", (Object)shutdownDelay);
        }
        health.setHealthStateAggregator(healthCheckManager);
        LOGGER.debug("Configured ongoing health check monitoring for healthChecks: {}", (Object)this.getHealthChecks());
    }

    private ScheduledExecutorService createScheduledExecutorForHealthChecks(int numberOfScheduledHealthChecks, MetricRegistry metrics, LifecycleEnvironment lifecycle, String fullName) {
        AtomicLong threadNum = new AtomicLong(0L);
        ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        ThreadFactory threadFactory = runnable -> {
            Thread thread = defaultThreadFactory.newThread(runnable);
            thread.setName(String.format("%s-%d", fullName, threadNum.incrementAndGet()));
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((t2, e) -> LOGGER.error("Thread={} died due to uncaught exception", (Object)t2, (Object)e));
            return thread;
        };
        InstrumentedThreadFactory instrumentedThreadFactory = new InstrumentedThreadFactory(threadFactory, metrics);
        ScheduledExecutorService scheduledExecutorService = lifecycle.scheduledExecutorService(fullName + "-scheduled-executor", instrumentedThreadFactory).threads(numberOfScheduledHealthChecks).build();
        return new InstrumentedScheduledExecutorService(scheduledExecutorService, metrics);
    }
}

