// Generated by delombok at Thu Sep 12 18:33:21 UTC 2024
package gov.cms.fiss.pricers.snf.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.snf.core.tables.NursingRateEntry.Fields;
import java.math.BigDecimal;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;

/**
 * Model for the Nursing CSV file.
 */
@Immutable
@JsonDeserialize(builder = NursingRateEntry.NursingRateEntryBuilder.class)
@JsonPropertyOrder({Fields.REGION, Fields.GROUP, Fields.RATE, Fields.AIDS_ADJUSTED_RATE, Fields.QUALITY_ADJUSTED_RATE, Fields.AIDS_AND_QUALITY_ADJUSTED_RATE})
public class NursingRateEntry {

  @JsonPOJOBuilder(withPrefix = "")
  public static class NursingRateEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String region;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String group;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal rate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal aidsAdjustedRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal qualityAdjustedRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal aidsAndQualityAdjustedRate;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    NursingRateEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NursingRateEntry.NursingRateEntryBuilder region(final String region) {
      this.region = region;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NursingRateEntry.NursingRateEntryBuilder group(final String group) {
      this.group = group;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NursingRateEntry.NursingRateEntryBuilder rate(final BigDecimal rate) {
      this.rate = rate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NursingRateEntry.NursingRateEntryBuilder aidsAdjustedRate(final BigDecimal aidsAdjustedRate) {
      this.aidsAdjustedRate = aidsAdjustedRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NursingRateEntry.NursingRateEntryBuilder qualityAdjustedRate(final BigDecimal qualityAdjustedRate) {
      this.qualityAdjustedRate = qualityAdjustedRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NursingRateEntry.NursingRateEntryBuilder aidsAndQualityAdjustedRate(final BigDecimal aidsAndQualityAdjustedRate) {
      this.aidsAndQualityAdjustedRate = aidsAndQualityAdjustedRate;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NursingRateEntry build() {
      return new NursingRateEntry(this.region, this.group, this.rate, this.aidsAdjustedRate, this.qualityAdjustedRate, this.aidsAndQualityAdjustedRate);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "NursingRateEntry.NursingRateEntryBuilder(region=" + this.region + ", group=" + this.group + ", rate=" + this.rate + ", aidsAdjustedRate=" + this.aidsAdjustedRate + ", qualityAdjustedRate=" + this.qualityAdjustedRate + ", aidsAndQualityAdjustedRate=" + this.aidsAndQualityAdjustedRate + ")";
    }
  }

  @Pattern(regexp = "RURAL|URBAN", message = "must be either RURAL or URBAN")
  private final String region;
  @Pattern(regexp = "[A-Y]", message = "must be single letter A-Y")
  private final String group;
  @Digits(integer = 4, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  private final BigDecimal rate;
  @Digits(integer = 4, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  private final BigDecimal aidsAdjustedRate;
  @Digits(integer = 4, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  private final BigDecimal qualityAdjustedRate;
  @Digits(integer = 4, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  private final BigDecimal aidsAndQualityAdjustedRate;

  public NursingRateEntryBuilder copyBuilder() {
    return NursingRateEntry.builder().region(getRegion()).group(getGroup()).rate(getRate()).aidsAdjustedRate(getAidsAdjustedRate()).qualityAdjustedRate(getQualityAdjustedRate()).aidsAndQualityAdjustedRate(getAidsAndQualityAdjustedRate());
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  NursingRateEntry(final String region, final String group, final BigDecimal rate, final BigDecimal aidsAdjustedRate, final BigDecimal qualityAdjustedRate, final BigDecimal aidsAndQualityAdjustedRate) {
    this.region = region;
    this.group = group;
    this.rate = rate;
    this.aidsAdjustedRate = aidsAdjustedRate;
    this.qualityAdjustedRate = qualityAdjustedRate;
    this.aidsAndQualityAdjustedRate = aidsAndQualityAdjustedRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static NursingRateEntry.NursingRateEntryBuilder builder() {
    return new NursingRateEntry.NursingRateEntryBuilder();
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof NursingRateEntry)) return false;
    final NursingRateEntry other = (NursingRateEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$region = this.getRegion();
    final java.lang.Object other$region = other.getRegion();
    if (this$region == null ? other$region != null : !this$region.equals(other$region)) return false;
    final java.lang.Object this$group = this.getGroup();
    final java.lang.Object other$group = other.getGroup();
    if (this$group == null ? other$group != null : !this$group.equals(other$group)) return false;
    final java.lang.Object this$rate = this.getRate();
    final java.lang.Object other$rate = other.getRate();
    if (this$rate == null ? other$rate != null : !this$rate.equals(other$rate)) return false;
    final java.lang.Object this$aidsAdjustedRate = this.getAidsAdjustedRate();
    final java.lang.Object other$aidsAdjustedRate = other.getAidsAdjustedRate();
    if (this$aidsAdjustedRate == null ? other$aidsAdjustedRate != null : !this$aidsAdjustedRate.equals(other$aidsAdjustedRate)) return false;
    final java.lang.Object this$qualityAdjustedRate = this.getQualityAdjustedRate();
    final java.lang.Object other$qualityAdjustedRate = other.getQualityAdjustedRate();
    if (this$qualityAdjustedRate == null ? other$qualityAdjustedRate != null : !this$qualityAdjustedRate.equals(other$qualityAdjustedRate)) return false;
    final java.lang.Object this$aidsAndQualityAdjustedRate = this.getAidsAndQualityAdjustedRate();
    final java.lang.Object other$aidsAndQualityAdjustedRate = other.getAidsAndQualityAdjustedRate();
    if (this$aidsAndQualityAdjustedRate == null ? other$aidsAndQualityAdjustedRate != null : !this$aidsAndQualityAdjustedRate.equals(other$aidsAndQualityAdjustedRate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof NursingRateEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $region = this.getRegion();
    result = result * PRIME + ($region == null ? 43 : $region.hashCode());
    final java.lang.Object $group = this.getGroup();
    result = result * PRIME + ($group == null ? 43 : $group.hashCode());
    final java.lang.Object $rate = this.getRate();
    result = result * PRIME + ($rate == null ? 43 : $rate.hashCode());
    final java.lang.Object $aidsAdjustedRate = this.getAidsAdjustedRate();
    result = result * PRIME + ($aidsAdjustedRate == null ? 43 : $aidsAdjustedRate.hashCode());
    final java.lang.Object $qualityAdjustedRate = this.getQualityAdjustedRate();
    result = result * PRIME + ($qualityAdjustedRate == null ? 43 : $qualityAdjustedRate.hashCode());
    final java.lang.Object $aidsAndQualityAdjustedRate = this.getAidsAndQualityAdjustedRate();
    result = result * PRIME + ($aidsAndQualityAdjustedRate == null ? 43 : $aidsAndQualityAdjustedRate.hashCode());
    return result;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String REGION = "region";
    public static final java.lang.String GROUP = "group";
    public static final java.lang.String RATE = "rate";
    public static final java.lang.String AIDS_ADJUSTED_RATE = "aidsAdjustedRate";
    public static final java.lang.String QUALITY_ADJUSTED_RATE = "qualityAdjustedRate";
    public static final java.lang.String AIDS_AND_QUALITY_ADJUSTED_RATE = "aidsAndQualityAdjustedRate";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRegion() {
    return this.region;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getGroup() {
    return this.group;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRate() {
    return this.rate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAidsAdjustedRate() {
    return this.aidsAdjustedRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getQualityAdjustedRate() {
    return this.qualityAdjustedRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAidsAndQualityAdjustedRate() {
    return this.aidsAndQualityAdjustedRate;
  }
}
