// Generated by delombok at Thu Sep 12 18:33:21 UTC 2024
package gov.cms.fiss.pricers.snf.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.snf.core.tables.SpeechLanguagePathologyRateEntry.Fields;
import java.math.BigDecimal;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;

/**
 * Model for the SLP CSV file.
 */
@Immutable
@JsonDeserialize(builder = SpeechLanguagePathologyRateEntry.SpeechLanguagePathologyRateEntryBuilder.class)
@JsonPropertyOrder({Fields.REGION, Fields.GROUP, Fields.RATE, Fields.QUALITY_ADJUSTED_RATE})
public class SpeechLanguagePathologyRateEntry {

  @JsonPOJOBuilder(withPrefix = "")
  public static class SpeechLanguagePathologyRateEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String region;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String group;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal rate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal qualityAdjustedRate;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    SpeechLanguagePathologyRateEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SpeechLanguagePathologyRateEntry.SpeechLanguagePathologyRateEntryBuilder region(final String region) {
      this.region = region;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SpeechLanguagePathologyRateEntry.SpeechLanguagePathologyRateEntryBuilder group(final String group) {
      this.group = group;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SpeechLanguagePathologyRateEntry.SpeechLanguagePathologyRateEntryBuilder rate(final BigDecimal rate) {
      this.rate = rate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SpeechLanguagePathologyRateEntry.SpeechLanguagePathologyRateEntryBuilder qualityAdjustedRate(final BigDecimal qualityAdjustedRate) {
      this.qualityAdjustedRate = qualityAdjustedRate;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SpeechLanguagePathologyRateEntry build() {
      return new SpeechLanguagePathologyRateEntry(this.region, this.group, this.rate, this.qualityAdjustedRate);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "SpeechLanguagePathologyRateEntry.SpeechLanguagePathologyRateEntryBuilder(region=" + this.region + ", group=" + this.group + ", rate=" + this.rate + ", qualityAdjustedRate=" + this.qualityAdjustedRate + ")";
    }
  }

  @Pattern(regexp = "RURAL|URBAN", message = "must be either RURAL or URBAN")
  private final String region;
  @Pattern(regexp = "[A-L]", message = "must be single letter A-L")
  private final String group;
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  @Digits(integer = 4, fraction = 2)
  private final BigDecimal rate;
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  @Digits(integer = 4, fraction = 2)
  private final BigDecimal qualityAdjustedRate;

  public SpeechLanguagePathologyRateEntryBuilder copyBuilder() {
    return SpeechLanguagePathologyRateEntry.builder().region(getRegion()).group(getGroup()).rate(getRate()).qualityAdjustedRate(getQualityAdjustedRate());
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  SpeechLanguagePathologyRateEntry(final String region, final String group, final BigDecimal rate, final BigDecimal qualityAdjustedRate) {
    this.region = region;
    this.group = group;
    this.rate = rate;
    this.qualityAdjustedRate = qualityAdjustedRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static SpeechLanguagePathologyRateEntry.SpeechLanguagePathologyRateEntryBuilder builder() {
    return new SpeechLanguagePathologyRateEntry.SpeechLanguagePathologyRateEntryBuilder();
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof SpeechLanguagePathologyRateEntry)) return false;
    final SpeechLanguagePathologyRateEntry other = (SpeechLanguagePathologyRateEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$region = this.getRegion();
    final java.lang.Object other$region = other.getRegion();
    if (this$region == null ? other$region != null : !this$region.equals(other$region)) return false;
    final java.lang.Object this$group = this.getGroup();
    final java.lang.Object other$group = other.getGroup();
    if (this$group == null ? other$group != null : !this$group.equals(other$group)) return false;
    final java.lang.Object this$rate = this.getRate();
    final java.lang.Object other$rate = other.getRate();
    if (this$rate == null ? other$rate != null : !this$rate.equals(other$rate)) return false;
    final java.lang.Object this$qualityAdjustedRate = this.getQualityAdjustedRate();
    final java.lang.Object other$qualityAdjustedRate = other.getQualityAdjustedRate();
    if (this$qualityAdjustedRate == null ? other$qualityAdjustedRate != null : !this$qualityAdjustedRate.equals(other$qualityAdjustedRate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof SpeechLanguagePathologyRateEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $region = this.getRegion();
    result = result * PRIME + ($region == null ? 43 : $region.hashCode());
    final java.lang.Object $group = this.getGroup();
    result = result * PRIME + ($group == null ? 43 : $group.hashCode());
    final java.lang.Object $rate = this.getRate();
    result = result * PRIME + ($rate == null ? 43 : $rate.hashCode());
    final java.lang.Object $qualityAdjustedRate = this.getQualityAdjustedRate();
    result = result * PRIME + ($qualityAdjustedRate == null ? 43 : $qualityAdjustedRate.hashCode());
    return result;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String REGION = "region";
    public static final java.lang.String GROUP = "group";
    public static final java.lang.String RATE = "rate";
    public static final java.lang.String QUALITY_ADJUSTED_RATE = "qualityAdjustedRate";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRegion() {
    return this.region;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getGroup() {
    return this.group;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRate() {
    return this.rate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getQualityAdjustedRate() {
    return this.qualityAdjustedRate;
  }
}
