******************************************************************************************
*The following is JCL if you are using an IBM-type mainframe:
*
*
*//JOBCARD
*//E1207D2P EXEC SAS8,REGION=1984K,
*// OPTIONS='ERRORS=0,NOCENTER,NEWS'
*//WORK  DD SPACE=(CYL,(1000,2))
*//WORK1   DD SPACE=(CYL,(2000,2))
*//LIBRARY DD DISP=SHR,DSN=XXXX.XXXXXXX  /* user-defined location of formats */
*//IN0 DD DISP=SHR,DSN=XXXX.XXXXXX       /*user-defined location of macros  */
*//IN1 DD DISP=SHR,DSN=XXXX.PERSON       /*the location of person-level file  */
*//IN2 DD DISP=SHR,DSN=XXXX.DIAG        /*the location of the diagnosis file */  
*//INPARM DD DISP=SHR,DSN=XXXX.HCCCOEFN /*the location of the file containing all coefficients */
*//OUT DD DISP=(NEW,CATLG,KEEP),
*//    DSN=XXX.E1207D2P.PERSON,         /*the output file containing person-level scores */ 
*//    SPACE=(TRK,(20,10),RLSE)
*//SYSIN  DD *
*
*
******************************************************************************************
*  If you are using PC-SAS, you must specify the location of the files 
*  on your PC in a libname/filename statement.
*
*LIBNAME LIBRARY "location of formats";
*FILENAME IN0 "location of macros";  
*LIBNAME IN1 "location of person-level file";
*LIBNAME IN2 "location of diagnosis file";
*LIBNAME INPARM "location of the coefficients file";
*LIBNAME OUT "location for the output file"; 
*
 /*********************************************************************
 * E1207D2P program creates seventy HCC variables (&CMSHCC) and fourteen
 * score variables for each person who is present in a person file
 * supplied by a user.
 * If a person has at least one diagnosis in DIAG file (supplied by a
 * user) then HCC variables are created, otherwise HCCs are set to 0.
 *
 * Assumptions about input files:
 *   - both files are sorted by person ID
 *   - person level file has the following variables:
 *     :&IDVAR  - person ID variable (it is a macro parameter)
 *     :DOB     - date of birth
 *     :SEX     - gender
 *     :OREC    - original reason for entitlement
 *     :MCAID   - Medicaid dummy variable
 *     :NEMCAID - Medicaid dummy variable for new enrollees
 *                
 *   - diagnosis level file has the following variables:
 *     :&IDVAR - person ID variable (it is macro parameter)
 *     :DIAG   - diagnosis
 *
 * The program supplies parameters and macro variables to a main macro
 * %E1207D2M that calls other external macros:
 *      %AGESEXVR - create age/sex, originally disabled, disabled vars
 *      %EDITICD9 - perform edits to diagnosis
 *      %V12H70M  - assign one ICD9 to multiple CCs
 *      %V12H70L  - assign labels to HCCs
 *      %E12H70H  - set HCC=0 according to hierarchies
 *      %SCOREVAR - calculate a score variable
 *
 * Comment: the format:
 *            $I1207YC - is specific for this version of the software
 *            (12- HCC version, 07- FY 2007 ICD9 update, Y- 70 HCCs set)
 *            $I&VR.C - VR=1207Y is a macro parameter for this
 *            update of ICD9. This parameter is set as the default
 *            in E1207D2M macro.
 *            With the new update of ICD9 the new format will be created
 *            and the value of parameter VR will have to be changed.
 *
 * Program steps:
 *         step1: include external macros
 *         step2: define internal macro variables
 *         step3: merge person and diagnosis files outputting one
 *                record per person for each input person level record
 *         step3.1: declaration section
 *         step3.2: bring regression coefficients
 *         step3.3: merge person and diagnosis file
 *         step3.4: for the first record for a person set CC to 0
 *                  and calculate age
 *         step3.5: if there are any diagnoses for a person
 *                  then do the following:
 *                   - create CC using format $I1207YC
 *                   - perform ICD9 edits using macro EDITICD9
 *                   - create additional CC using V12H70M macro
 *         step3.6: for the last record for a person do the
 *                  following:
 *                   - create demographic variables needed
 *                     for regressions (macro AGESEXVR)
 *                   - create dimographic interaction variables
 *                   - create HCC using hierarchies (macro V12H70H)
 *                   - create HCC interaction variables
 *                   - create HCC and DISABL interaction variables
 *                   - set to 0 HCCs and interaction variables if there
 *                     are no diagnoses for a person
 *                   - create 14 score variables:
 *   SCORE_DIAL                     - dialysis score
 *   SCORE_DIAL_NE                  - dialysis new enrollees score
 *       kidney only transplant:
 *   SCORE_TRANS_KIDNEY_ONLY_1M     - first month score
 *   SCORE_TRANS_KIDNEY_ONLY_2M     - second month score
 *   SCORE_TRANS_KIDNEY_ONLY_3M     - third month score
 *       kidney plus pancreas transplant:
 *   SCORE_TRANS_KIDNEY_PANCREAS_1M - first month score
 *   SCORE_TRANS_KIDNEY_PANCREAS_2M - second month score
 *   SCORE_TRANS_KIDNEY_PANCREAS_3M - third month score
 *       4-9 months duration of functioning graft:
 *   SCORE_GRAFT_COMM_DUR4_9        - community graft score
 *   SCORE_GRAFT_INST_DUR4_9        - institutional graft score
 *   SCORE_GRAFT_NE_DUR4_9          - new enrollee's graft score
 *       10+ months duration of functioning graft:
 *   SCORE_GRAFT_COMM_DUR10PL       - community graft score
 *   SCORE_GRAFT_INST_DUR10PL       - institutional graft score
 *   SCORE_GRAFT_NE_DUR10PL         - new enrollee's graft score
 *
 *         step4: data checks and proc contents
 *
 *   USER CUSTOMIZATION:
 * A user must supply 2 files with the variables described above and
 * set the following parameters:
 *      INP       - SAS input person dataset
 *      IND       - SAS input diagnosis dataset
 *      OUTDATA   - SAS output dataset
 *      IDVAR     - name of person id variable (HICNO for Medicare data)
 *      KEEPVAR   - variables to keep in the output dataset
 *      SEDITS    - a switch that controls whether to perform edits on 
 *                  ICD9: 1-YES, 0-NO
 *      DATE_ASOF - as of date to calculate age (February 1 of 2003 
 *                  is current used as default)
 *      DF_DG     - normalization factor set by CMS, used to multiply 
 *                  dialysis and graft scores (currently set to 1 
 *                  by default)
 *      DF_POSTG  - normalization factor set by CMS, used to multiply 
 *                  post-graft scores (currently set to 1 by default)
 * A user can add variables to the list of variables suggested in 
 * KEEPVAR parameter
 *********************************************************************/;

 %LET IDVAR=HICNO;
 %LET INPUTVARS=%STR(&IDVAR SEX DOB MCAID NEMCAID OREC );

 %*some of demographic variables created by the software;
 %LET DEMVARS  =%STR(AGEF DISABL ORIGDS
                     F0_34  F35_44 F45_54 F55_59 F60_64 F65_69
                     F70_74 F75_79 F80_84 F85_89 F90_94 F95_GT
                     M0_34  M35_44 M45_54 M55_59 M60_64 M65_69
                     M70_74 M75_79 M80_84 M85_89 M90_94 M95_GT
                     M85_GT F85_GT 

                     NEF0_34  NEF35_44 NEF45_54 NEF55_59 NEF60_64
                     NEF65    NEF66    NEF67    NEF68    NEF69
                     NEF70_74 NEF75_79 NEF80_84 NEF85_89 NEF90_94
                     NEF95_GT
                     NEM0_34  NEM35_44 NEM45_54 NEM55_59 NEM60_64
                     NEM65    NEM66    NEM67    NEM68    NEM69
                     NEM70_74 NEM75_79 NEM80_84 NEM85_89 NEM90_94
                     NEM95_GT);
  *list of HCCs included in models;
 %LET CMSHCC = %STR(HCC1    HCC2    HCC5   HCC7   HCC8   HCC9
                    HCC10   HCC15   HCC16  HCC17  HCC18  HCC19
                    HCC21   HCC25   HCC26  HCC27  HCC31  HCC32
                    HCC33   HCC37   HCC38  HCC44  HCC45  HCC51
                    HCC52   HCC54   HCC55  HCC67  HCC68  HCC69
                    HCC70   HCC71   HCC72  HCC73  HCC74  HCC75
                    HCC77   HCC78   HCC79  HCC80  HCC81  HCC82
                    HCC83   HCC92   HCC95  HCC96  HCC100 HCC101
                    HCC104  HCC105  HCC107 HCC108 HCC111 HCC112
                    HCC119  HCC130  HCC131 HCC132 HCC148 HCC149
                    HCC150  HCC154  HCC155 HCC157 HCC158 HCC161
                    HCC164  HCC174  HCC176 HCC177);

 %LET SCOREVARS=%STR(SCORE_DIAL
                     SCORE_DIAL_NE
                     SCORE_TRANS_KIDNEY_ONLY_1M
                     SCORE_TRANS_KIDNEY_ONLY_2M
                     SCORE_TRANS_KIDNEY_ONLY_3M
                     SCORE_TRANS_KIDNEY_PANCREAS_1M
                     SCORE_TRANS_KIDNEY_PANCREAS_2M
                     SCORE_TRANS_KIDNEY_PANCREAS_3M
                     SCORE_GRAFT_COMM_DUR4_9
                     SCORE_GRAFT_INST_DUR4_9
                     SCORE_GRAFT_NE_DUR4_9
                     SCORE_GRAFT_COMM_DUR10PL
                     SCORE_GRAFT_INST_DUR10PL
                     SCORE_GRAFT_NE_DUR10PL
                     DF_DG
                     DF_POSTG);

  %INCLUDE IN0(E1207D2M)/SOURCE2; *include main macro ;

  *MACRO call;
  %E1207D2M (INP      =IN1.PERSON,
             IND      =IN2.DIAG,
             OUTDATA  =OUT.PERSON,
             IDVAR    =&IDVAR,
             KEEPVAR  =&INPUTVARS &SCOREVARS &DEMVARS &CMSHCC,
             SEDITS   =1,
             AGE_ASOF ="1FEB2003"D,
             DF_DG    =1,
             DF_POSTG =1);
