

* PROGRAM: OOPCV1P.SAS;
* DESCRIPTION: MAIN OOPC PROGRAM;

%LET INPUTDIR    = c:\oopc\input;
%LET PROGDIR     = c:\oopc\programs;
%LET PBPDIR      = c:\program files\pbp2017;
%LET FORMDIR     = c:\oopc\formulary;
%LET PLANFILEDIR = c:\oopc\programs;
%LET OUTPUT      = c:\oopc\output\;

%LET INPUT=INPUTPLAN;

OPTIONS OBS = MAX NOCENTER MSGLEVEL = N SUMSIZE = 1000M BUFNO = 6
   SORTPGM = SAS  NOSORTEQUALS THREADS = YES NOTES;
OPTIONS VALIDVARNAME=ANY;

OPTIONS NOMPRINT NOSOURCE2;
RUN;

FILENAME IN0     "&INPUTDIR.";
LIBNAME  IN1     "&INPUTDIR.";

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****BEGIN OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;


*SET UP MACRO VARIABLES FOR YEARS;
%LET PBPMAIN       = PBP2017.MDB;
%LET YEAR1         = 2011;
%LET YEAR2         = 2012;
%LET RUNYEAR       = 2017;
%LET MCBSYR1       = 'MCBS 11';
%LET MCBSYR2       = 'MCBS 12';
%LET PARTB_PREMIUM = 109.00; 
%LET DRUG_INF_YR1  = 1.26;
%LET DRUG_INF_YR2  = 1.28; 
%LET PARTA_DEDUCT  = 1316.00;
%LET PARTB_DEDUCT  = 183.00;
%LET GENERIC_GAP_DISCOUNT = 0.49;
%LET BRAND_GAP_DISCOUNT = 0.50;
%LET BRAND_GAP_LIABDISC = 0.10;
%LET DEDUCTIBLE_&RUNYEAR = 400;
%LET ICL_&RUNYEAR = 3700;
%LET TROOP_&RUNYEAR = 4950;
%LET THRESHOLD_&RUNYEAR = 7425.00;
%LET CATGENERIC_&RUNYEAR = 3.30;
%LET CATBRAND_&RUNYEAR = 8.25;
%LET B1_DED_AMT=1316;
%LET B1_COPAY_BGND_INT1=1;
%LET B1_COPAY_BGND_INT2=61;
%LET B1_COPAY_BGND_INT3=91;
%LET B1_COPAY_ENDD_INT1=60;
%LET B1_COPAY_ENDD_INT2=90;
%LET B1_COPAY_ENDD_INT3=150;
%LET B1_COPAY_AMT_INT1=0;
%LET B1_COPAY_AMT_INT2=329;
%LET B1_COPAY_AMT_INT3=658;
%LET B2_COPAY_AMT_INT1=0;
%LET B2_COPAY_AMT_INT2=164.50;
%LET B2_COPAY_BGND_INT1=1;
%LET B2_COPAY_BGND_INT2=21;
%LET B2_COPAY_BGND_INT3=.;
%LET B2_COPAY_ENDD_INT1=20;
%LET B2_COPAY_ENDD_INT2=100;
%LET B2_COPAY_ENDD_INT3=.;

%macro obsnvars(ds);
   %global dset nvars nobs;
   %let dset=&ds;
   %let dsid = %sysfunc(open(&dset));
   %if &dsid %then
      %do;
         %let nobs =%sysfunc(attrn(&dsid,NOBS));
         %let nvars=%sysfunc(attrn(&dsid,NVARS));
         %let rc = %sysfunc(close(&dsid));
      %end;
   %else
      %put Open for data set &dset failed - %sysfunc(sysmsg());
%mend obsnvars;

%INCLUDE IN0(OOPCV1M.SAS)/SOURCE2;
run;

data _null_;
  ddate = put(date(),YYMMDDN8.);
  put ddate=;
  call symput('file_date', trim(left(ddate)));
run;

%OOPCV1M(RUNYEAR           =2017,
         INP               =IN1.PERSON,
         INC               =IN1.UTILIZATION,
         CATEG             =IN1.CATEGORY,
         PBP               =&PBPDIR,
         FORMULARY         =&FORMDIR,
         PLANFILE          =&PLANFILEDIR\PLANFILE.TXT,
         OOPC              =&OUTPUT.OOPC_RUN&file_date..xlsx);  
run;

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****ENDED OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;
