* PROGRAM: BASEID_DRUGS.SAS;
* DESCRIPTION: BASEID_PLAN_CATEGORY.SAS;

%MACRO GETCOUNT(TYP);
PROC SORT DATA=&TYP._COST_CALCS_&YEAR(KEEP=BASEID HPLAN TOTAL_OOPC)
          OUT=&TYP._COST_CALCS;
BY HPLAN BASEID;
RUN;

PROC SORT DATA=&TYP._COST_CALCS(KEEP=BASEID) NODUPKEY
          OUT=&TYP._BASEID;
BY BASEID;
RUN;

PROC SORT DATA=&TYP._COST_CALCS(KEEP=HPLAN) NODUPKEY
          OUT=&TYP._HPLAN;
BY HPLAN;
RUN;
%MEND;
RUN;

%GETCOUNT(DS);
RUN;
%GETCOUNT(AE);
RUN;
%GETCOUNT(BA);
RUN;
%GETCOUNT(EA);
RUN;

DATA LIST_HPLAN_TYPE_&CLASS._&YEAR(KEEP=HPLAN MRX_TYPE);
LENGTH MRX_TYPE $ 3;
 SET DS_HPLAN(IN=A)
     BA_HPLAN(IN=B)
     AE_HPLAN(IN=C)
     EA_HPLAN(IN=D);
 IF A THEN MRX_TYPE='DS';
 ELSE IF B THEN MRX_TYPE='BA';
 ELSE IF C THEN MRX_TYPE='AE';
 ELSE IF D THEN MRX_TYPE='EA';
 RUN;

%MACRO NOCOST(TYP);
DATA &TYP._BASEID_NOCOST;
 MERGE &TYP._BASEID(IN=A)
       &INP(IN=B KEEP=BASEID YEAR WHERE=(YEAR="&YEAR"));
BY BASEID;
IF NOT A AND B THEN OUTPUT;
RUN;

DATA _NULL_;
NAME = "&TYP._HCNT";
PUT NAME=;
CALL SYMPUT(NAME,TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET &TYP._HPLAN NOBS=NUMOBS;
STOP;
RUN;

DATA &TYP._NOCOST;
 SET &TYP._BASEID_NOCOST;
 DO I = 1 TO &&&TYP._HCNT;
       SET &TYP._HPLAN POINT=I;
       OUTPUT;
 END;
RUN;

DATA &TYP._COST_CALCS_ALL;
  SET &TYP._COST_CALCS(IN=A)
      &TYP._NOCOST(IN=B);
IF B THEN DO;
   TOTAL_OOPC=0;
   END;
RUN;

PROC SORT DATA=&TYP._COST_CALCS_ALL;
BY HPLAN;
RUN;
%MEND;
RUN;

%NOCOST(DS);
RUN;
%NOCOST(AE);
RUN;
%NOCOST(BA);
RUN;
%NOCOST(EA);
RUN;

DATA COST_CALCS_ALL;
 LENGTH MRX_TYPE $ 3;
 SET DS_COST_CALCS_ALL(IN=A)
     BA_COST_CALCS_ALL(IN=B)
     AE_COST_CALCS_ALL(IN=C)
     EA_COST_CALCS_ALL(IN=D);
 IF A THEN MRX_TYPE='DS';
 IF B THEN MRX_TYPE='BA';
 IF C THEN MRX_TYPE='AE';
 IF D THEN MRX_TYPE='EA';
 RUN;

PROC SORT DATA=COST_CALCS_ALL;
  BY HPLAN BASEID;
RUN;

DATA CAT15;
  LENGTH CATEGORY $4;
  SET COST_CALCS_ALL(KEEP=BASEID HPLAN TOTAL_OOPC MRX_TYPE);
  CATEGORY='PTD';
  AMTTOT=TOTAL_OOPC;
  COST_SHARE_COST = 0;
  OTHER_COST = 0;
  KEEP BASEID HPLAN COST_SHARE_COST OTHER_COST CATEGORY AMTTOT MRX_TYPE;
RUN;

PROC SUMMARY DATA = CAT15 NWAY MISSING;
  CLASS HPLAN CATEGORY BASEID;
  VAR COST_SHARE_COST OTHER_COST AMTTOT;
  OUTPUT OUT = PBPCATS_15 (DROP=_TYPE_ _FREQ_) SUM=;
RUN;

PROC SORT DATA=PBPCATS_15;
BY BASEID;
RUN;

DATA BASEID_PLAN_CATEGORY;
  MERGE PBPCATS_15(IN = A)
        &INP(IN = B KEEP = BASEID INDMON CELL_GROUP CSYRWGT YEAR WHERE=(YEAR="&YEAR"));
  BY BASEID;
  IF A;

  COST = AMTTOT;
  MONTHLY_COST = COST / INDMON;
  *MONTHLY_COST_CHECK = COST_CHECK / INDMON;
  DROP INDMON;
  RENAME CSYRWGT = CWGT;

RUN;

PROC SORT DATA=BASEID_PLAN_CATEGORY;
BY BASEID HPLAN;
RUN;

DATA BASEID_PLAN_CATEGORY_ALL_ALL;
  SET BASEID_PLAN_CATEGORY;
  BY BASEID HPLAN;

  RETAIN TOT_COSTS /* TOT_COSTS_CHECK */;

  OUTPUT;

  IF FIRST.HPLAN THEN TOT_COSTS = 0;
  *IF FIRST.HPLAN THEN TOT_COSTS_CHECK = 0;

  TOT_COSTS + MONTHLY_COST;
  *TOT_COSTS_CHECK + MONTHLY_COST_CHECK;

  IF LAST.HPLAN THEN DO;
    CATEGORY = 'ALL';
    MONTHLY_COST = TOT_COSTS;
    *MONTHLY_COST_CHECK = TOT_COSTS_CHECK;
    OUTPUT;
  END;

  DROP TOT_COSTS /* TOT_COSTS_CHECK */;

RUN;

DATA BASEID_PLAN_CATEGORY_ALL;
 SET BASEID_PLAN_CATEGORY_ALL_ALL;
IF CATEGORY='ALL' THEN DELETE;
RUN;

PROC SORT DATA = BASEID_PLAN_CATEGORY_ALL OUT=BASEID_PLAN_CATEGORY_ALL;
  BY HPLAN CATEGORY CELL_GROUP;
RUN;


* ADD THE MISSING MEMBERS OF THE COHORT WITH NO UTILIZATION;
* FOR EACH PLAN/CATEGORY ADD A ROW FOR EACH CELL_GROUP FOR THE PEOPLE WITH NO UTILIZATION;
* FOR EACH PLAN WRITE OUT AN ALL CATEGORY ROW FOR EACH MISSING PERSON;

DATA BASEID_PLAN_CATEGORY_PARTD_&YEAR;
  *IF _N_ = 1 THEN SET MISSING_CELLS_&YEAR;
  SET BASEID_PLAN_CATEGORY_ALL;
  BY HPLAN CATEGORY;

  ARRAY ACWGT  CWGT1 - CWGT30;
  ARRAY ACELL  CELL1 - CELL30;

  OUTPUT;

  KEEP BASEID HPLAN CATEGORY CWGT COST CELL_GROUP MONTHLY_COST YEAR;
RUN;

PROC SORT DATA=LIST_HPLAN_TYPE_&CLASS._&YEAR;
BY HPLAN;
RUN;

PROC SORT DATA=BASEID_PLAN_CATEGORY_PARTD_&YEAR;
BY HPLAN;
RUN;

DATA BASEID_PLAN_CATEGORY_&CLASS._&YEAR;
 MERGE BASEID_PLAN_CATEGORY_PARTD_&YEAR(IN=A)
       LIST_HPLAN_TYPE_&CLASS._&YEAR(IN=B);
BY HPLAN;
IF A;
RUN;

PROC SORT DATA = BASEID_PLAN_CATEGORY_&CLASS._&YEAR;
  BY CELL_GROUP HPLAN CATEGORY;
RUN;

PROC SORT DATA=BASEID_PLAN_CATEGORY_PARTD_&YEAR;
BY CELL_GROUP HPLAN CATEGORY;
RUN;

