
* PROGRAM: COST_SHARING_DIALYSIS.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR DIALYSIS CLAIMS;


%MACRO DIALYSIS_COST_SHARE(SERV_CAT);

  DATA DIALYSIS_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='12'));
  RUN;
  
  DATA DIALYSIS_FILE;
    SET  PBP_FILE(KEEP =
                  CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                  PBP_B12_MAXENR_AMT PBP_B12_MAXENR_PER
                  PBP_B12_COPAY_MC_AMT PBP_B12_COINS_PCT_MC
                  PBP_B12_DED_AMT
                  PBP_A_PLAN_TYPE
                  PBP_D_DIFF_DEDUCT_12_AMT);
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B12_MAXENR_PER,PBP_B12_MAXENR_AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM DIALYSIS_BASEID B, DIALYSIS_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;
      
  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='12'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;
    
    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_12_AMT;
    ELSE CAT_DEDUCTIBLE=PBP_B12_DED_AMT;
    
    IF PBP_B12_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B12_MAXENR_AMT;

    IF CAT_DEDUCTIBLE = . THEN DO;
      COST = SUM(COST,(VISITS * PBP_B12_COPAY_MC_AMT));
      COST = SUM(COST,AMTTOT * PBP_B12_COINS_PCT_MC);
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        COST = SUM(COST,(VISITS * PBP_B12_COPAY_MC_AMT));
        COST = SUM(COST,AMTTOT * PBP_B12_COINS_PCT_MC);
      END;
    END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN 
      COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "12";
  RUN;

  PROC APPEND DATA=DIALYSIS(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE DIALYSIS DIALYSIS_BASEID DIALYSIS_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;

