* PROGRAM: OOPCV3P.SAS;
* DESCRIPTION: MAIN OOPC PROGRAM;

%LET INPUTDIR = c:\oopc\input;
%LET PROGDIR  = c:\oopc\programs;
%LET PBPDIR   = c:\program files\pbp2012;
%LET FORMDIR  = c:\oopc\formulary;
%LET OUTPUT   = c:\oopc\output\OOPC_RUN1_APR302011.xls;

OPTIONS OBS=MAX NOCENTER MSGLEVEL = N SUMSIZE = 1000M BUFNO=6
   SORTPGM=SAS  NOSORTEQUALS THREADS=YES NOTES;

OPTIONS NOMPRINT NOSOURCE2;
RUN;

FILENAME IN0 "&INPUTDIR.";
LIBNAME  IN1 "&INPUTDIR.";

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****BEGIN OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;

*SET UP MACRO VARIABLES FOR YEARS;
%LET YEAR1 = 2005;
%LET YEAR2 = 2006;
%LET RUNYEAR = 2012;


%LET MCBSYR1 = 'MCBS 05';
%LET MCBSYR2 = 'MCBS 06';
%LET PBPMAIN = PBP2012.MDB;

%INCLUDE IN0(OOPCV3M.SAS)/SOURCE2;
run;

data _null_;
  ddate = put(date(),YYMMDDN8.);
  put ddate=;
  call symput('file_date', trim(left(ddate)));
run;

%OOPCV3M(RUNYEAR   =2012,
         INP       =IN1.PERSON,

         INC       =IN1.UTILIZATION,
         PBP       =&PBPDIR,
         FORMULARY =&FORMDIR,
         OOPC      =&OUTPUT,
         PLANFILE  =&PROGDIR\PLANFILE.TXT);
run;

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****ENDED OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;
