* PROGRAM: BASEID_MSA.SAS;

** read the pbp plan data for each of the cost categories;
data cat11b;
  length category $3;
  set supplies
      orthotics;

*keep the msas and a few plans with different combinations of deductible and oop max
 for the msas will need pbp_d_msa_ded_amt and pbp_d_msa_annual_amt;


** 2011 **;
IF PUT(HPLAN,$TYPEF.) = 'MSA';

  if cost_share_cost = . then cost_share_cost = 0;
  if other_cost = . then other_cost = 0;

  keep baseid year hplan cost_share_cost other_cost category amttot;

run;

proc summary data = cat11b nway missing;
  class YEAR hplan category baseid;
  var cost_share_cost other_cost amttot;
  output out = pbpcats_11b (drop=_type_ _freq_) sum=;
run;


data pbpcats_temp;
  length category $3;
  set pbpcats_11b costdata;

** 2011 **;
IF PUT(HPLAN,$TYPEF.) = 'MSA';

  if cost_share_cost     = . then cost_share_cost = 0;
  if cost_share_cost_mc  = . then cost_share_cost_mc = 0;
  if cost_share_cost_amo = . then cost_share_cost_amo = 0;
  if other_cost          = . then other_cost = 0;

  if category in ('15','16') then do;
    amttot_amo = 0;
    amttot_mc = 0;
   end;
  else do;
    amttot_amo = 0;
    amttot_mc = sum(amttot,-other_cost);
  end;

  keep baseid YEAR hplan category amttot cost_share_cost cost_share_cost_mc cost_share_cost_amo other_cost
       amttot_amo amttot_mc;
run;

*create one record for each plan type;
** 2011 **;
data msa_plans(KEEP=HPLAN);
set PBP_FILE;
if put(HPLAN,$TYPEF.) = 'MSA';
run;

DATA _NULL_;
CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,2.))));
STOP;
SET MSA_PLANS NOBS=NUMOBS;
STOP;
RUN;

data pbpcats;
 set pbpcats_temp;
run;

DATA PBPCATS_&YEAR1 PBPCATS_&YEAR2;
SET PBPCATS;
IF YEAR = "&YEAR1" THEN OUTPUT PBPCATS_&YEAR1;
ELSE IF YEAR = "&YEAR2" THEN OUTPUT PBPCATS_&YEAR2;
RUN;

%MACRO PROCMSA;
proc sort data = pbpcats_&YEAR out = pbpcats;
  by baseid hplan category;
run;

*******;
*** get the plan deductible and cms contribution from the pbp data;
*******;

data pbp_data;
  set PBP_FILE(keep=hplan pbp_d_msa_ded_amt pbp_d_msa_annual_amt);

** 2011 **;
IF PUT(HPLAN,$TYPEF.) = 'MSA';
run;

proc sort data = pbp_data;
  by hplan;
run;

******;
***summarize the data to create the "all" category.
***create all category summing up monthly cost across categories
***for a person plan;
******;

**Not clear why the old code used this data step instead of a proc summary;
**will follow this method.;

data baseid_plan_category_all;
  set pbpcats;
  by baseid hplan;

  retain tot_tot tot_amo tot_mc tot_other;

  output;

  if first.hplan then
     do;
     *cost_cost = 0;
     *tot_costs = 0;
      tot_tot   = 0;
      tot_amo   = 0;
      tot_mc    = 0;
      tot_other = 0;
     end;
      *cost_cost + cost;
      *tot_costs + monthly_cost;
      tot_tot   + amttot;
      tot_amo   + amttot_amo;
      tot_mc    + amttot_mc;
      tot_other + other_cost;

  if last.hplan then do;
    category = 'all';
    *cost         = cost_cost;
    *monthly_cost = tot_costs;
    amttot       = tot_tot;
    amttot_amo   = tot_amo;
    amttot_mc    = tot_mc;
    other_cost   = tot_other;
   output;
  end;

  drop tot_tot tot_amo tot_mc tot_other;
run;

proc sort data = baseid_plan_category_all;
  by YEAR hplan category;
run;

data baseid_plan_category_all_msa;
 merge baseid_plan_category_all(where=(category='all'))
       pbp_data;
by hplan;
run;

******;
***compute the new reduction amounts;
******;

data baseid_plan_costs;
 set baseid_plan_category_all_msa;

if amttot_mc < pbp_d_msa_annual_amt < pbp_d_msa_ded_amt
   then
     do;
      oopc_mc=0;
      balance=pbp_d_msa_annual_amt - amttot_mc;
     end;

if amttot_mc >= pbp_d_msa_annual_amt and
   amttot_mc <  pbp_d_msa_ded_amt
   then
     do;
       oopc_mc=amttot_mc - pbp_d_msa_annual_amt;
       balance = 0;
     end;

 if amttot_mc >= pbp_d_msa_ded_amt
    then
      do;
        oopc_mc= pbp_d_msa_ded_amt - pbp_d_msa_annual_amt;
        balance = 0;
      end;
run;

proc sort data=baseid_plan_category_all;
by hplan baseid;
run;

proc sort data=baseid_plan_costs;
by hplan baseid;
run;

*******;
***now aportion the costs bec. the balance (if positive) can only be spent
***on valid health care expenses (our assumption);
*******;

**now output the records that have positive other costs that may
  be paid for out of the balance just calculated. categories are
  1a (inpat acute), 1b (inpat psych), 2 (snf), 15 (drugs), and 16
  (dental) and combine with the balance amount just calculated;
*rename other_cost from the 'all' data set so that there is the total
 across the non medicare costs;
data baseid_plan_costs_nonmc;
 merge baseid_plan_costs(in=a keep=baseid hplan balance other_cost oopc_mc
                              rename=(other_cost=other_cost_sum ))
       baseid_plan_category_all(in=b where=(category='1a' or category='1b' or
                                            category='2'  or
                                            category='15' or category='16'));
by hplan baseid;

*keep only those baseids with 1a, 1b, 2, 15 and/or 16 because those with neither cannot
 spend the balance;
if a and b;

*ratio of the nonmc cost by category to total nonmc cost;
*apply portion to balance BUT only if costs are positive. we have records where the
 amttot is positive but the other_cost is zero;
*also must make sure that the balance is not greater than the sum of the costs;
if balance > other_cost_sum then
   balance = other_cost_sum;

if other_cost > 0 then
    reduction=(other_cost/other_cost_sum) * balance;
else reduction=0;

*substract the reduction from the costs;
other_cost_adj = other_cost - reduction;

run;

data baseid_plan_costs_mc;
 merge baseid_plan_costs(in=a keep=baseid hplan oopc_mc amttot_mc
                            rename=(amttot_mc=amttot_mc_sum))
       baseid_plan_category_all(in=b
where=(
category='1a'  or
category='1b'  or
category='2'   or
category='10a' or
category='11a' or
category='11b' or
category='12 ' or
category='14d' or
category='14h' or
category='15m' or
category='15c' or
category='16b' or
category='17a' or
category='17b' or
category='18a' or
category='3  ' or
category='4a ' or
category='4b ' or
category='6  ' or
category='7a ' or
category='7b ' or
category='7c ' or
category='7d ' or
category='7e ' or
category='7f ' or
category='7g ' or
category='7h ' or
category='7i ' or
category='8al' or
category='8ad' or
category='8br' or
category='8bd' or
category='8bx' or
category='9a ' or
category='9b ' or
category='9d '));

by hplan baseid;

*keep only those baseids with any cost but 15 or 16 because need to adjust
 these for total oopc for mc;
if a and b;

*ratio of the mc cost by category to total mc cost;
if amttot_mc > 0 then
   amttot_mc_adj = (amttot_mc/amttot_mc_sum) * oopc_mc;
else amttot_mc_adj = 0;

run;

proc sort data=baseid_plan_costs_mc;
by baseid hplan category;
run;

proc sort data=baseid_plan_costs_nonmc;
by baseid hplan category;
run;


***now combine the records--need to merge the 1a,1b, 2 and then set the
   mc for the rest and the nonmc for 15 and 16;
data baseid_plan_costs_12;
 merge baseid_plan_costs_mc(where=(category='1a' or
                                   category='1b' or
                                   category='2'))
      baseid_plan_costs_nonmc(where=(category='1a' or
                                      category='1b' or
                                      category='2')
                              drop=amttot
                                   amttot_amo
                                   amttot_mc
                                   cost_share_cost
                                   cost_share_cost_amo
                                   cost_share_cost_mc
                                   oopc_mc
                                   other_cost YEAR);
by baseid hplan category;
run;

*now set these with the other nonmc records;
data baseid_plan_costs_adjusted;
 set baseid_plan_costs_12
     baseid_plan_costs_nonmc(where=(category='15' or
                                    category='16')
                              drop=/* amttot
                                   amttot_amo
                                   amttot_mc
                                   cost_share_cost
                                   cost_share_cost_amo
                                   cost_share_cost_mc
                                   oopc_mc
                                   other_cost */)
     baseid_plan_costs_mc(where=(
category='10a' or
category='11a' or
category='11b' or
category='12 ' or
category='14d' or
category='14h' or
category='15m' or
category='15c' or
category='16b' or
category='17a' or
category='17b' or
category='18a' or
category='3  ' or
category='4a ' or
category='4b ' or
category='6  ' or
category='7a ' or
category='7b ' or
category='7c ' or
category='7d ' or
category='7e ' or
category='7f ' or
category='7g ' or
category='7h ' or
category='7i ' or
category='8ad' or
category='8al' or
category='8br' or
category='8bx' or
category='8bd' or
category='9a ' or
category='9b ' or
category='9d '));
run;

proc sort data=baseid_plan_costs_adjusted;
by baseid hplan category;
run;

data baseid_plan_costs_adjusted_names(drop=amttot_mc_adj other_cost_adj);
 set baseid_plan_costs_adjusted(drop=balance reduction oopc_mc other_cost
                                     amttot_mc other_cost_sum amttot_mc_sum);

*reset the medicare costs that also have an other component;
if category='1a' or
   category='1b' or
   category='2'  then
    do;
      other_cost=other_cost_adj;
      amttot_mc =amttot_mc_adj;
    end;

*reset the medicare costs that only have a mc component;
else if
category='10a' or
category='11a' or
category='11b' or
category='12 ' or
category='14d' or
category='14h' or
category='15m' or
category='15c' or
category='16b' or
category='17a' or
category='17b' or
category='18a' or
category='3  ' or
category='4a ' or
category='4b ' or
category='6  ' or
category='7a ' or
category='7b ' or
category='7c ' or
category='7d ' or
category='7e ' or
category='7f ' or
category='7g ' or
category='7h ' or
category='7i ' or
category='8al ' or
category='8ad' or
category='8bd' or
category='8bx' or
category='8br' or
category='9a ' or
category='9b ' or
category='9d ' then
  do;
    other_cost=0;
    amttot_mc=amttot_mc_adj;
  end;

*reset the non medicare that only have an other component;
else if category='15' or
        category='16' then
    do;
      other_cost=other_cost_adj;
      amttot_mc=0;
    end;

cost_share_cost_mc = amttot_mc;
cost_share_cost_amo = amttot_amo;
cost_share_cost = sum(cost_share_cost_mc, cost_share_cost_amo, other_cost);
cost = sum(cost_share_cost_mc, cost_share_cost_amo, other_cost);
run;

*** monthly cost for people with utilization by category;

PROC SORT DATA=&INP OUT=PERSON;
WHERE (YEAR = "&YEAR");
BY BASEID;
RUN;

data baseid_plan_category_final;
     merge baseid_plan_costs_adjusted_names(in = a)
           PERSON(in = b keep = baseid indmon cell_group csyrwgt);
  by baseid;
  if a;

  monthly_cost = cost / indmon;

  drop indmon;
  rename csyrwgt = cwgt;

run;

* create all category summing up monthly cost across categories;
* for a person plan;

data baseid_plan_category_final_all;
  set baseid_plan_category_final;
  by baseid hplan;

  retain tot_costs tot_costs_check;

  output;

  if first.hplan then tot_costs = 0;
  if first.hplan then tot_costs_check = 0;

  tot_costs + monthly_cost;
  tot_costs_check + monthly_cost_check;

  if last.hplan then do;
    category = 'all';
    monthly_cost = tot_costs;
    monthly_cost_check = tot_costs_check;
    output;
  end;

  drop tot_costs tot_costs_check;
run;

proc sort data = baseid_plan_category_final_all;
  by hplan category cell_group;
run;

* add the missing members of the cohort with no utilization;
* for each plan/category add a row for each cell_group for the people with no utilization;
* for each plan write out an all category row for each missing person;

data baseid_plan_category_completemsa;
  if _n_ = 1 then set missing_cells_&YEAR;
  set baseid_plan_category_final_all;
  by hplan category;

  array acwgt cwgt1 - cwgt30;
  array acell   cell1   - cell30;

  output;


  if last.hplan then do;
    do i = 1 to 30;
      category = 'all';
      cell_group = acell(i);
      baseid = 'miss' !! left(put(i,2.));
      cwgt = acwgt(i);
      cost = 0;
      monthly_cost = 0;
      if acell(i) ne '' then output;
    end;
  end;

  keep baseid hplan category cwgt cost cell_group monthly_cost;
run;

proc sort data = baseid_plan_category_completemsa;
  by cell_group hplan category;
run;

proc freq data = baseid_plan_category_completemsa;
  tables hplan category cell_group;
title 'baseid_plan_category_complete dataset';
run;

***sort for print ***;
proc sort data=baseid_plan_category_completemsa OUT=BASEID_PLAN_CATEGORY_MSA_&YEAR;
by CELL_GROUP HPLAN CATEGORY;
run;
%MEND;
RUN;

%LET YEAR = &YEAR1;
%PROCMSA;
RUN;
%LET YEAR = &YEAR2;
%PROCMSA;
RUN;
