
* PROGRAM: COST_SHARING_HEARINGEXAMS.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR HEARINGEXAMS CLAIMS;

DATA HEARINGEXAMS_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='18a'));
RUN;

data HEARINGEXAMS_FILE;
    SET  PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B18A_DED_AMT PBP_B18A_MAXENR_AMT
                   PBP_B18A_MAXENR_PER PBP_B18A_MED_COINS_PCT
                   PBP_B18A_COPAY_AMT);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from HEARINGEXAMS_BASEID b, HEARINGEXAMS_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO HEARINGEXAMS_COST_SHARE(SERV_CAT);

%LET SERV_CAT = HEARINGEXAMS;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B18A_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B18A_MAXENR_AMT;

      IF PBP_B18A_DED_AMT = . THEN DO;
        COST = SUM(COST,(VISITS*PBP_B18A_COPAY_AMT));
        COST = SUM(COST,AMTTOT*PBP_B18A_MED_COINS_PCT);
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B18A_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
          COST = PBP_B18A_DED_AMT;
          DEDUCT_SHARE = PBP_B18A_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B18A_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST,(VISITS*PBP_B18A_COPAY_AMT));
          COST = SUM(COST,AMTTOT*PBP_B18A_MED_COINS_PCT);
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "18a";
  RUN;

%MEND HEARINGEXAMS_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=HEARINGEXAMS;
RUN;

%HEARINGEXAMS_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=HEARINGEXAMS(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE HEARINGEXAMS HEARINGEXAMS_BASEID HEARINGEXAMS_FILE CAT_JOIN;
QUIT;
RUN;
