* PROGRAM:  PBP_DRUG_VARIABLES.SAS;
* DESCRIPTION: PREPARE THE DRUG VARIABLES;

LIBNAME FORM "&FORMULARY";

LIBNAME LIBRARY "&INPUTDIR";

* ESTABLISH &RUNYEAR PARAMETERS;
%LET DEDUCTIBLE_&RUNYEAR = 320;
%LET ICL_&RUNYEAR = 2930;
%LET TROOP_&RUNYEAR = 4700;
%LET THRESHOLD_&RUNYEAR = 6657.50;
%LET CATGENERIC_&RUNYEAR = 2.60;
%LET CATBRAND_&RUNYEAR = 6.50;

DATA PBP_MRX_MRG;
  MERGE PBP_MRX (IN=A) PBP_FILE_PARTD(IN=B KEEP=HPLAN CONTRACT_ID PLAN_ID);
  BY HPLAN;
  IF A & B;
RUN;

* BENEFIT INPUT;

DATA PBP_MRX;
  SET PBP_MRX_MRG;
  * ASSIGN VARIABLE TYPES;
  IF MRX_DRUG_BEN_YN = '1' THEN DO;
    SELECT(MRX_BENEFIT_TYPE);
      WHEN('1') DO;
        PLAN_DEDUCTIBLE = &&DEDUCTIBLE_&RUNYEAR.;
        PLAN_ICL = &&ICL_&RUNYEAR.;
        PLAN_THRESHOLD = &&THRESHOLD_&RUNYEAR.;
      END;
      WHEN('2') DO;
        PLAN_DEDUCTIBLE = &&DEDUCTIBLE_&RUNYEAR.;
        PLAN_ICL = &&ICL_&RUNYEAR.;
        PLAN_THRESHOLD = &&THRESHOLD_&RUNYEAR.;
      END;
      WHEN('3') DO;
        IF MRX_ALT_COV_LMT_YN = '1' THEN PLAN_ICL = &&ICL_&RUNYEAR.;
        ELSE IF MRX_ALT_COV_LMT_YN = '2' THEN PLAN_ICL = MRX_ALT_COV_LMT_AMT;
        ELSE IF MRX_ALT_COV_LMT_YN = '3' THEN PLAN_ICL = &&THRESHOLD_&RUNYEAR.;

        IF MRX_ALT_DED_CHARGE = '1' THEN PLAN_DEDUCTIBLE = &&DEDUCTIBLE_&RUNYEAR.;
        ELSE IF MRX_ALT_DED_CHARGE = '2' THEN PLAN_DEDUCTIBLE = MRX_ALT_DED_AMOUNT;
        ELSE IF MRX_ALT_DED_CHARGE = '3' THEN PLAN_DEDUCTIBLE = 0;

        PLAN_THRESHOLD = &&THRESHOLD_&RUNYEAR.;

      END;
      WHEN('4') DO;
        IF MRX_ALT_COV_LMT_YN = '1' THEN PLAN_ICL = &&ICL_&RUNYEAR.;
        ELSE IF MRX_ALT_COV_LMT_YN = '2' THEN PLAN_ICL = MRX_ALT_COV_LMT_AMT;
        ELSE IF MRX_ALT_COV_LMT_YN = '3' THEN PLAN_ICL = &&THRESHOLD_&RUNYEAR.;

        IF MRX_ALT_DED_CHARGE = '1' THEN PLAN_DEDUCTIBLE = &&DEDUCTIBLE_&RUNYEAR.;
        ELSE IF MRX_ALT_DED_CHARGE = '2' THEN PLAN_DEDUCTIBLE = MRX_ALT_DED_AMOUNT;
        ELSE IF MRX_ALT_DED_CHARGE = '3' THEN PLAN_DEDUCTIBLE = 0;

        PLAN_THRESHOLD = &&THRESHOLD_&RUNYEAR.;

      END;
      OTHERWISE;
    END;
    IF (MRX_BENEFIT_TYPE = '1') OR
       (MRX_BENEFIT_TYPE = '2' AND MRX_AE_CSTSHR_APPLY='1') OR
       (MRX_BENEFIT_TYPE = '3' AND MRX_ALT_PRE_ICL_COST_SHARE = '2') OR
       (MRX_BENEFIT_TYPE = '4' AND MRX_ALT_PRE_ICL_COST_SHARE = '2') THEN DO;
      PLAN_COPAY = .;
      PLAN_COINS = 25;
    END;
    ELSE IF (MRX_BENEFIT_TYPE = '3' AND MRX_ALT_PRE_ICL_COST_SHARE = '1') OR
          (MRX_BENEFIT_TYPE = '4' AND MRX_ALT_PRE_ICL_COST_SHARE = '1') THEN DO;
      PLAN_COPAY = 0;
      PLAN_COINS = 0;
    END;
    IF (MRX_BENEFIT_TYPE IN ('1','2','3')) OR
         (MRX_BENEFIT_TYPE = '4' AND MRX_ALT_GAP_COVG_YN = '2') THEN DO;
      PLAN_COPAY_GAP = .;
      PLAN_COINS_GAP = .;
    END;

    IF (MRX_BENEFIT_TYPE = '1') OR
         (MRX_BENEFIT_TYPE = '2' AND MRX_AE_OOPTCS_APPLY = '1') OR
         (MRX_BENEFIT_TYPE = '3' AND MRX_ALT_CSTSHR_POST_OOPT = '2') OR
         (MRX_BENEFIT_TYPE = '4' AND MRX_ALT_CSTSHR_POST_OOPT = '2') THEN DO;
      PLAN_COPAY_CAT_GEN = &&CATGENERIC_&RUNYEAR.;
      PLAN_COPAY_CAT_BRAND = &&CATBRAND_&RUNYEAR.;
      PLAN_COINS_CAT_GEN = .;
      PLAN_COINS_CAT_BRAND = .;
    END;
    ELSE IF (MRX_BENEFIT_TYPE = '3' AND MRX_ALT_CSTSHR_POST_OOPT = '1') OR
            (MRX_BENEFIT_TYPE = '4' AND MRX_ALT_CSTSHR_POST_OOPT = '1') THEN DO;
      PLAN_COPAY_CAT_GEN = 0;
      PLAN_COPAY_CAT_BRAND = 0;
      PLAN_COINS_CAT_GEN = 0;
      PLAN_COINS_CAT_BRAND = 0;
    END;

    IF MRX_BENEFIT_TYPE IN ('3','4') AND MRX_ALT_DED_TYPE_YN = '2' THEN DO;
      PLAN_COINS_PRE = MRX_ALT_GEN_COINS_PCT;
      PLAN_COPAY_PRE = MRX_ALT_GEN_COPAY_AMT;
    END;

  END;
  IF PLAN_COINS NE .           THEN PLAN_COINS           =  PLAN_COINS / 100;
  IF PLAN_COINS_CAT_GEN NE .   THEN PLAN_COINS_CAT_GEN   =  PLAN_COINS_CAT_GEN / 100;
  IF PLAN_COINS_CAT_BRAND NE . THEN PLAN_COINS_CAT_BRAND =  PLAN_COINS_CAT_BRAND / 100;
  IF PLAN_COINS_GAP NE .       THEN PLAN_COINS_GAP       =  PLAN_COINS_GAP / 100;
  IF PLAN_COINS_PRE NE .       THEN PLAN_COINS_PRE       =  PLAN_COINS_PRE / 100;

  KEEP MRX_DRUG_BEN_YN MRX_BENEFIT_TYPE PLAN_DEDUCTIBLE PLAN_ICL PLAN_THRESHOLD MRX_AE_CSTSHR_APPLY
       MRX_AE_OOPTCS_APPLY MRX_ALT_PRE_ICL_COST_SHARE MRX_ALT_CSTSHR_POST_OOPT
       PLAN_COPAY PLAN_COINS PLAN_COPAY_CAT_GEN PLAN_COINS_CAT_GEN
       PLAN_COPAY_CAT_BRAND PLAN_COINS_CAT_BRAND PLAN_COPAY_GAP PLAN_COINS_GAP MRX_ALT_GAP_COVG_YN
       MRX_ALT_DED_TYPE_YN MRX_ALT_NO_DED_TIER MRX_ALT_DED_TIER_CSTSHR_YN
       HPLAN PLAN_COPAY_PRE PLAN_COINS_PRE MRX_ALT_GEN_CSTSHR_STRUCT CONTRACT_ID PLAN_ID;
RUN;

PROC SORT DATA = PBP_MRX NODUPKEY;
  BY HPLAN;
RUN;

PROC SORT DATA=PBP_MRX_TIER OUT = PBP_MRX_TIERS;
  BY HPLAN MRX_TIER_ID MRX_TIER_TYPE_ID;
RUN;

DATA PBP_MRX_P;
  LENGTH CONTRACT_ID $5 PLAN_ID $3;
  SET PBP_MRX_P;
  CONTRACT_ID = SUBSTR(HPLAN,1,5);
  PLAN_ID = SUBSTR(HPLAN,6,3);
  RENAME MRX_TIER_POST_COST_STRUCT = MRX_TIER_CSTSHR_STRUCT_TYPE
         MRX_TIER_POST_ID = MRX_TIER_ID
         MRX_TIER_POST_TYPE_ID = MRX_TIER_TYPE_ID
         MRX_TIER_POST_COPAY_AMT = MRX_TIER_INPP_COPAY_1M
         MRX_TIER_POST_COINS_PCT = MRX_TIER_INPP_COINS_1M;
  KEEP MRX_TIER_POST_COST_STRUCT MRX_TIER_POST_ID MRX_TIER_POST_TYPE_ID
       MRX_TIER_POST_COPAY_AMT  MRX_TIER_POST_COINS_PCT HPLAN CONTRACT_ID PLAN_ID;
RUN;

PROC SORT DATA = PBP_MRX_P;
  BY HPLAN MRX_TIER_ID MRX_TIER_TYPE_ID;
RUN;

%let dsid=%sysfunc(open(PBP_MRX_P));
%let pobs=%sysfunc(attrn(&dsid,nlobs));
%let rc=%sysfunc(close(&dsid));

%macro comb();
  DATA COMBINE;
    SET PBP_MRX_TIERS
        %if &pobs. > 0 %then %do;
          PBP_MRX_P
        %end;
       ;
    BY HPLAN MRX_TIER_ID MRX_TIER_TYPE_ID;
  RUN;

%mend;

%comb();

DATA COMBINE_MRG;
  MERGE COMBINE (IN=A) PBP_FILE_PARTD (IN=B KEEP=HPLAN);
  BY HPLAN;
  IF A & B;
RUN;

DATA PBP_T (RENAME = STRUCT_TYPE = MRX_TIER_CSTSHR_STRUCT_TYPE);
  SET COMBINE_MRG;
  BY HPLAN MRX_TIER_ID MRX_TIER_TYPE_ID;
  RETAIN PLAN_COPAY PLAN_COINS PLAN_COPAY_CAT PLAN_COINS_CAT PLAN_COPAY_GAP PLAN_COINS_GAP STRUCT_TYPE;
  ARRAY D PLAN_COPAY PLAN_COINS PLAN_COPAY_CAT PLAN_COINS_CAT PLAN_COPAY_GAP PLAN_COINS_GAP;
  LENGTH STRUCT_TYPE $3;
  IF FIRST.MRX_TIER_ID THEN DO;
    DO I = 1 TO 6;
      D(I) = .;
    END;
    STRUCT_TYPE  = '000';
  END;
  IF MRX_TIER_TYPE_ID = '1' THEN  SUBSTR(STRUCT_TYPE,1,1) = MRX_TIER_CSTSHR_STRUCT_TYPE;
  ELSE IF MRX_TIER_TYPE_ID = '2' THEN  SUBSTR(STRUCT_TYPE,2,1) = MRX_TIER_CSTSHR_STRUCT_TYPE;
  ELSE IF MRX_TIER_TYPE_ID = '3' THEN  SUBSTR(STRUCT_TYPE,3,1) = MRX_TIER_CSTSHR_STRUCT_TYPE;
  ARRAY CP MRX_TIER_INPP_COPAY_1M MRX_TIER_INP_COPAY_1M MRX_TIER_INNPP_COPAY_1M MRX_TIER_OONP_COPAY_1M;
  ARRAY CN MRX_TIER_INPP_COINS_1M MRX_TIER_INP_COINS_1M MRX_TIER_INNPP_COINS_1M MRX_TIER_OONP_COINS_1M;
  SELECT;
    WHEN(MRX_TIER_CSTSHR_STRUCT_TYPE = '1') DO;
      FOUND_FLAG = '0';
      DO I = 1 TO 4;
        IF FOUND_FLAG = '0' AND CN(I) NE . THEN DO;
          FOUND_FLAG = '1';
          SELECT(MRX_TIER_TYPE_ID);
            WHEN('1') PLAN_COINS = CN(I);
            WHEN('2') PLAN_COINS_CAT = CN(I);
            WHEN('3') DO;
              IF MRX_TIER_GAP_COST_SHARE IN ('1','2') & MRX_TIER_GAP_EXCLUDED_ONLY_YN NE '1' THEN DO;
                GAP_COVERAGE_FLAG = MRX_TIER_GAP_COST_SHARE;
                PLAN_COINS_GAP = CN(I);
              END;
            END;
            OTHERWISE;
          END;
        END;
      END;
    END;
    WHEN(MRX_TIER_CSTSHR_STRUCT_TYPE = '2') DO;
      FOUND_FLAG = '0';
      DO I = 1 TO 4;
        IF FOUND_FLAG = '0' AND CP(I) NE . THEN DO;
          FOUND_FLAG = '1';
          SELECT(MRX_TIER_TYPE_ID);
            WHEN('1') PLAN_COPAY = CP(I);
            WHEN('2') PLAN_COPAY_CAT = CP(I);
            WHEN('3') DO;
              IF MRX_TIER_GAP_COST_SHARE IN ('1','2')  & MRX_TIER_GAP_EXCLUDED_ONLY_YN NE '1' THEN DO;
                GAP_COVERAGE_FLAG = MRX_TIER_GAP_COST_SHARE;
                PLAN_COPAY_GAP = CP(I);
              END;
            END;
            OTHERWISE;
          END;
        END;
      END;
    END;
    WHEN(MRX_TIER_CSTSHR_STRUCT_TYPE  IN ('3','4')) DO;
      FOUND_FLAG_CP = '0';
      FOUND_FLAG_CN = '0';
      DO I = 1 TO 4;
        IF FOUND_FLAG_CN = '0' AND CN(I) NE . THEN DO;
          FOUND_FLAG_CN = '1';
          SELECT(MRX_TIER_TYPE_ID);
            WHEN('1') PLAN_COINS = CN(I);
            WHEN('2') PLAN_COINS_CAT = CN(I);
            WHEN('3') DO;
              IF MRX_TIER_GAP_COST_SHARE IN ('1','2')  & MRX_TIER_GAP_EXCLUDED_ONLY_YN NE '1' THEN DO;
                GAP_COVERAGE_FLAG = MRX_TIER_GAP_COST_SHARE;
                PLAN_COINS_GAP = CN(I);
              END;
            END;
            OTHERWISE;
          END;
        END;
        IF FOUND_FLAG_CP = '0' AND CP(I) NE . THEN DO;
          FOUND_FLAG_CP = '1';
          SELECT(MRX_TIER_TYPE_ID);
            WHEN('1') PLAN_COPAY = CP(I);
            WHEN('2') PLAN_COPAY_CAT = CP(I);
            WHEN('3') DO;
              IF MRX_TIER_GAP_COST_SHARE IN ('1','2')  & MRX_TIER_GAP_EXCLUDED_ONLY_YN NE '1' THEN DO;
                GAP_COVERAGE_FLAG = MRX_TIER_GAP_COST_SHARE;
                PLAN_COPAY_GAP = CP(I);
              END;
            END;
            OTHERWISE;
          END;
        END;
      END;
    END;
    OTHERWISE;
  END;
  IF LAST.MRX_TIER_ID;
  IF PLAN_COINS NE .     THEN PLAN_COINS = PLAN_COINS / 100;
  IF PLAN_COINS_CAT NE . THEN PLAN_COINS_CAT = PLAN_COINS_CAT / 100;
  IF PLAN_COINS_GAP NE . THEN PLAN_COINS_GAP = PLAN_COINS_GAP / 100;
  KEEP MRX_TIER_ID PLAN_COPAY PLAN_COINS HPLAN
       PLAN_COPAY_CAT PLAN_COINS_CAT
       PLAN_COPAY_GAP PLAN_COINS_GAP GAP_COVERAGE_FLAG STRUCT_TYPE;
RUN;

PROC SORT DATA = PBP_T;
  BY HPLAN;
RUN;


DATA PLAN_FORM;
LENGTH CONTPLN $8;
SET FORM.PLAN_FORMULARY;
CONTPLN = CONTRACT_ID!!PLAN_ID;
IF PUT(CONTPLN,$CONTPLNF.) NE 'NO';
RUN;

PROC SORT DATA=PLAN_FORM OUT=PLANFORM (KEEP=CONTRACT_ID PLAN_ID FORMULARY_ID) NODUPKEY;
  BY CONTRACT_ID PLAN_ID;
RUN;

DATA MRX_TEMP1;
  MERGE PBP_MRX (IN = A)
        PBP_T (IN = B RENAME=(PLAN_COINS=PLAN_COINS_T PLAN_COPAY=PLAN_COPAY_T
              PLAN_COINS_GAP=PLAN_COINS_GAP_T PLAN_COPAY_GAP=PLAN_COPAY_GAP_T));
  BY HPLAN;
  IF A;
  TIERFLAG=B;
RUN;

DATA MRX_TEMP2;
  MERGE MRX_TEMP1 (IN=A)
        PLANFORM (IN=B);
  BY CONTRACT_ID PLAN_ID;
  IF A;
  PLANFORMFLAG=B;
RUN;

PROC SORT DATA=MRX_TEMP2 OUT=MRX_TEMP_SORT;
  BY FORMULARY_ID;
RUN;

PROC SORT DATA=FORM.FORMULARY OUT=FORMSORT (KEEP=FORMULARY_ID TIER_LEVEL_VALUE) NODUPKEY;
  BY FORMULARY_ID TIER_LEVEL_VALUE;
RUN;

DATA FORMROLL (KEEP=FORMULARY_ID T1-T10 TCNT);
  SET FORMSORT;
  BY FORMULARY_ID TIER_LEVEL_VALUE;
  RETAIN T1-T10 TCNT;
  ARRAY T(10) T1-T10;
  IF FIRST.FORMULARY_ID THEN DO;
    TCNT=0;
    DO I=1 TO 10;
      T(I)=.;
    END;
  END;
  TCNT+1;
  T(TCNT)=TIER_LEVEL_VALUE;
  IF LAST.FORMULARY_ID THEN OUTPUT;
RUN;

DATA MRX_TEMP_FORM;
  MERGE MRX_TEMP_SORT (IN=A) FORMROLL (IN=B);
  BY FORMULARY_ID;
  IF A;
  FORMFLAG=B;
RUN;

DATA MRX_TEMP3;
  SET MRX_TEMP_FORM;
  IF PLAN_COINS=. & PLAN_COINS_T NE . THEN PLAN_COINS=PLAN_COINS_T;
  IF PLAN_COPAY=. & PLAN_COPAY_T NE . THEN PLAN_COPAY=PLAN_COPAY_T;
  IF PLAN_COINS_GAP=. & PLAN_COINS_GAP_T NE . THEN PLAN_COINS_GAP=PLAN_COINS_GAP_T;
  IF PLAN_COPAY_GAP=. & PLAN_COPAY_GAP_T NE . THEN PLAN_COPAY_GAP=PLAN_COPAY_GAP_T;
  ARRAY T(10) T1-T10;
  IF FORMFLAG=1 & MRX_TIER_ID=' ' & MRX_BENEFIT_TYPE IN ('2','3','4') THEN DO;
    DO I=1 TO TCNT;
      MRX_TIER_ID=LEFT(PUT(T(I),2.));
      OUTPUT;
    END;
  END;
  ELSE OUTPUT;
RUN;

DATA MRX_EXTRACT;
  SET MRX_TEMP3 (DROP= PLAN_COINS_T PLAN_COPAY_T PLAN_COINS_GAP_T PLAN_COPAY_GAP_T
    TIERFLAG PLANFORMFLAG FORMFLAG TCNT T1-T10 I CONTRACT_ID PLAN_ID);
  if mrx_alt_ded_type_yn ='2' then do;
    if mrx_alt_ded_tier_cstshr_yn = '1' then do;
      mrx_alt_gen_cstshr_struct = SUBSTR(mrx_tier_cstshr_struct_type,1,1);
      PLAN_COINS_PRE = PLAN_COINS;
      PLAN_COPAY_PRE = PLAN_COPAY;
    end;
  end;
LENGTH PLAN_COINS PLAN_COINS_CAT PLAN_COINS_CAT_BRAND PLAN_COINS_CAT_GEN PLAN_COINS_GAP PLAN_COINS_PRE
         PLAN_COPAY PLAN_COPAY_CAT PLAN_COPAY_CAT_BRAND PLAN_COPAY_CAT_GEN PLAN_COPAY_GAP PLAN_COPAY_PRE
         PLAN_DEDUCTIBLE PLAN_ICL PLAN_THRESHOLD 5;
RUN;
