
* PROGRAM: COST_SHARING_EDUCATION_DIABETES.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR EDUCATION DIABETES CLAIMS;

DATA DIAB_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='14e'));
RUN;

data diab_file;
    SET  PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B14E_MAXENR_AMT PBP_B14E_MAXENR_PER
                   PBP_B14E_COPAY_MC_MIN_AMT
                   PBP_B14E_COINS_PCT
                   PBP_B14E_DED_AMT );
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from diab_baseid b, diab_file p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO DIAB_COST_SHARE(SERV_CAT);

  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B14E_MAXENR_AMT = . THEN DO;
      MAXENR_AMT = PBP_B14E_MAXENR_AMT;
      MAXENR_PER = PBP_B14E_MAXENR_PER;
    END;
    ELSE DO;
      MAXENR_AMT = PBP_B14E_MAXENR_AMT;
      MAXENR_PER = PBP_B14E_MAXENR_PER;
    END;

    IF MAXENR_AMT NE . THEN BENE_MAXIMUM = MAXENR_AMT;

      IF PBP_B14E_DED_AMT = . THEN DO;
        COST = SUM(COST,(VISITS*PBP_B14E_COPAY_MC_MIN_AMT));
        COST = SUM(COST,(AMTTOT*PBP_B14E_COINS_PCT));
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B14E_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
          COST = PBP_B14E_DED_AMT;
          DEDUCT_SHARE = PBP_B14E_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B14E_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST,(VISITS*PBP_B14E_COPAY_MC_MIN_AMT));
          COST = SUM(COST,(AMTTOT*PBP_B14E_COINS_PCT));
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "14e";
  RUN;

%MEND DIAB_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=DIAB;
RUN;
%DIAB_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=DIAB(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE DIAB DIAB_BASEID DIAB_FILE CAT_JOIN;
QUIT;
RUN;
