
* PROGRAM: COST_SHARING_EYEEXAMS.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR EYEEXAMS CLAIMS;

DATA EYEEXAMS_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='17a'));
RUN;

data EYEEXAMS_FILE;
    SET  PBP_FILE(KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B17A_DED_AMT PBP_B17A_MAXENR_AMT
                   PBP_B17A_MAXENR_PER PBP_B17A_COINS_MCMIN_PCT PBP_B17A_COPAY_MCMIN_AMT);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from EYEEXAMS_BASEID b, EYEEXAMS_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO EYEEXAMS_COST_SHARE(SERV_CAT);

%LET SERV_CAT = EYEEXAMS;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);

    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B17A_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B17A_MAXENR_AMT;

      IF PBP_B17A_DED_AMT = . THEN DO;
        COST = SUM(COST,(VISITS*PBP_B17A_COPAY_MCMIN_AMT));
        COST = SUM(COST,AMTTOT*PBP_B17A_COINS_MCMIN_PCT);
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B17A_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
          COST = PBP_B17A_DED_AMT;
          DEDUCT_SHARE = PBP_B17A_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B17A_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST,(VISITS*PBP_B17A_COPAY_MCMIN_AMT));
          COST = SUM(COST,AMTTOT*PBP_B17A_COINS_MCMIN_PCT);
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "17a";
  RUN;

%MEND EYEEXAMS_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=EYEEXAMS;
RUN;

%EYEEXAMS_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=EYEEXAMS(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE EYEEXAMS EYEEXAMS_BASEID EYEEXAMS_FILE CAT_JOIN;
QUIT;
RUN;
