
* PROGRAM: COST_SHARING_MEDICARE_DENTAL.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR MEDICARE DENTAL CLAIMS;

DATA MDENTAL_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='16b'));
RUN;

data MDENTAL_FILE;
    SET  PBP_FILE(KEEP=
        CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
        PBP_B16B_MAXENR_AMT PBP_B16B_MAXENR_PER
        PBP_B16B_COPAY_MC_AMT PBP_B16B_COINS_PCT_MC
        PBP_B16B_DED_AMT);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from MDENTAL_BASEID b, MDENTAL_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO MDENTAL_COST_SHARE(SERV_CAT);

%LET SERV_CAT = MDENTAL;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);

    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B16B_MAXENR_AMT ^ = . THEN BENE_MAX = PBP_B16B_MAXENR_AMT;

    COST = .;

    COST = SUM(COST, VISITS * PBP_B16B_COPAY_MC_AMT);
    COST = SUM(COST, AMTTOT * PBP_B16B_COINS_PCT_MC);
    IF BENE_MAX >= 0 AND COST >= 0 THEN COST = MIN(COST, BENE_MAX);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "16b";
  RUN;

%MEND MDENTAL_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=MDENTAL;
RUN;
%MDENTAL_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=MDENTAL(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE MDENTAL MDENTAL_BASEID MDENTAL_FILE CAT_JOIN;
QUIT;
RUN;
