* PBPCATS.SAS;
* DESCRIPTION: COMBINE ALL CATEGORIES TOGETHER;

DATA CAT11B;
  LENGTH CATEGORY $3;
  SET  SUPPLIES
       ORTHOTICS;
  IF COST_SHARE_COST = . THEN COST_SHARE_COST = 0;
  IF OTHER_COST = . THEN OTHER_COST = 0;
  KEEP YEAR BASEID HPLAN CATEGORY COST_SHARE_COST OTHER_COST AMTTOT COST_SHARE_COST_MC COST_SHARE_COST_AMO;
RUN;

PROC SUMMARY DATA=CAT11B NWAY MISSING;
  CLASS YEAR HPLAN CATEGORY BASEID;
  VAR COST_SHARE_COST OTHER_COST AMTTOT COST_SHARE_COST_MC COST_SHARE_COST_AMO;
  OUTPUT OUT= ORTHOTICS_SUPPLIES (DROP=_TYPE_ _FREQ_) SUM=;
RUN;

DATA PBPCATS_TEMP;
  LENGTH CATEGORY $3;
  SET    COSTDATA  ORTHOTICS_SUPPLIES;
  IF HPLAN NE '';

  IF COST_SHARE_COST     = . THEN COST_SHARE_COST = 0;
  IF COST_SHARE_COST_MC  = . THEN COST_SHARE_COST_MC = 0;
  IF COST_SHARE_COST_AMO = . THEN COST_SHARE_COST_AMO = 0;
  IF OTHER_COST          = . THEN OTHER_COST = 0;
  IF CATEGORY IN ('15','16') THEN DO;
    AMTTOT_AMO = SUM(AMTTOT,-OTHER_COST);
    AMTTOT_MC = 0;
  END;
  ELSE DO;
    AMTTOT_AMO = 0;
    AMTTOT_MC = SUM(AMTTOT,-OTHER_COST);
  END;
 
  IF PUT(HPLAN,$TYPEF.) = 'MSA' THEN DO;
    COST_SHARE_COST_MC = AMTTOT_MC;
    COST_SHARE_COST_AMO = OTHER_COST;
    OTHER_COST=0;
  END;
 
  KEEP BASEID YEAR HPLAN CATEGORY
  AMTTOT COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST AMTTOT_AMO AMTTOT_MC;
RUN;

PROC SORT DATA = PBPCATS_TEMP OUT =  PBPCATS_MCCOST;
  BY HPLAN CATEGORY;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
*DELETE SUPPLIES ORTHOTICS CAT11B;
RUN;
