
* PROGRAM: PBP_CMS.SAS;
* DESCRIPTION: READ IN PBP DATA;

LIBNAME LIBRARY "&INPUTDIR";
LIBNAME DATADIR "&PBPDIR";

%LET INPBP =DATADIR.PBP_FILE;
%LET INMRX =DATADIR.MRX_FILE;

%MACRO PLANS;
%IF "&PLANFILE" NE "" %THEN %DO;
*READ THE PLANFILE;
DATA PLANFILE;
INFILE "&PLANFILE" encoding=unicode;
INPUT @1 HPLAN $CHAR11.;
RUN;

PROC PRINT DATA=PLANFILE;
TITLE 'PLANFILE';
RUN;
%END;
%ELSE %DO;
DATA PLANFILE;
STOP;
RUN;
%END;
%MEND;
RUN;

%PLANS;
RUN;

%MACRO SNPPLANS;
%IF "&SNPPLANFILE" NE "" %THEN %DO;
*READ THE SNP PLANFILE;
DATA SNPPLANFILE;
INFILE "&SNPPLANFILE" encoding=unicode;
INPUT @1 HPLAN $CHAR11.;
RUN;

PROC PRINT DATA=SNPPLANFILE;
TITLE 'SNPPLANFILE';
RUN;
%END;
%ELSE %DO;
DATA SNPPLANFILE;
STOP;
RUN;
%END;
%MEND;
RUN;

%SNPPLANS;
RUN;

DATA _NULL_;
CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET PLANFILE NOBS=NUMOBS;
STOP;
RUN;

%MACRO FMT;
%IF &NUM > 0 %THEN %DO;
DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
  SET PLANFILE (RENAME=HPLAN=START) END=LAST;
  LENGTH FMTNAME $8 LABEL $3 HLO $1;
  FMTNAME='$HPLANF';
  LABEL='YES';
  HLO=' ';
  OUTPUT;
  IF LAST THEN DO;
    START='OTHER';
    LABEL='NO';
    HLO='O';
    OUTPUT;
  END;
RUN;
%END;
%ELSE %DO;
DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
  LENGTH FMTNAME $8 LABEL $3 HLO $1;
  FMTNAME='$HPLANF';
  START='OTHER';
  LABEL='YES';
  HLO='O';
  OUTPUT;
RUN;
%END;
RUN;
%MEND;
RUN;

%FMT;
RUN;

PROC FORMAT CNTLIN=HPLAN_FMT LIBRARY=LIBRARY;
RUN;

DATA PBPPLANS MAPD MAON PDP MSA FFS MGAP;
SET &INPBP(KEEP=HPLAN TYPE PBP_A_PLAN_TYPE PBP_A_SPECIAL_NEED_PLAN_TYPE MRX_DRUG_BEN_YN PBP_A_ORG_TYPE);
*SUBSET FOR HPLAN HERE;
IF PUT(HPLAN,$HPLANF.) = 'YES';
IF TYPE = 'PDP' THEN OUTPUT PDP;
ELSE IF TYPE = 'MAPD' THEN OUTPUT MAPD;
ELSE IF TYPE = 'MAON' THEN OUTPUT MAON;
ELSE IF TYPE = 'MSA' THEN OUTPUT MSA;
ELSE IF TYPE = 'FFS' THEN OUTPUT FFS;
ELSE IF TYPE = 'MGAP' THEN OUTPUT MGAP;
OUTPUT PBPPLANS;
RUN;

PROC SORT DATA=PBPPLANS;
BY HPLAN;
RUN;

PROC PRINT DATA=PBPPLANS(OBS=25);
TITLE 'PBPPLANS';
RUN;

%GLOBAL MAON PDP MAPD MSA FFS MGAP;
RUN;

DATA _NULL_;
CALL SYMPUT('MAON',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET MAON NOBS=NUMOBS;
STOP;
RUN;

DATA _NULL_;
CALL SYMPUT('PDP',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET PDP NOBS=NUMOBS;
STOP;
RUN;

DATA _NULL_;
CALL SYMPUT('MAPD',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET MAPD NOBS=NUMOBS;
STOP;
RUN;

DATA _NULL_;
CALL SYMPUT('MSA',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET MSA NOBS=NUMOBS;
STOP;
RUN;

DATA _NULL_;
CALL SYMPUT('FFS',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET FFS NOBS=NUMOBS;
STOP;
RUN;

DATA _NULL_;
CALL SYMPUT('MGAP',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET MGAP NOBS=NUMOBS;
STOP;
RUN;

%PUT _USER_;

DATA _NULL_;
CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET PBPPLANS NOBS=NUMOBS;
STOP;
RUN;

%MACRO FMT;
%IF &NUM > 0 %THEN %DO;
DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
  SET PBPPLANS (RENAME=HPLAN=START) END=LAST;
  LENGTH FMTNAME $8 LABEL $4 HLO $1;
  FMTNAME='$TYPEF';
  LABEL=TYPE;
  HLO=' ';
  OUTPUT;
  IF LAST THEN DO;
    START='OTHER';
    LABEL='NO';
    HLO='O';
    OUTPUT;
  END;
RUN;
%END;
%ELSE %DO;
DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
  LENGTH FMTNAME $8 LABEL $4 HLO $1;
  FMTNAME='$TYPEF';
  START='OTHER';
  LABEL='NO';
  HLO='O';
  OUTPUT;
RUN;
%END;
RUN;
%MEND;
RUN;

%FMT;
RUN;

PROC FORMAT CNTLIN=PLAN_FMT LIBRARY=LIBRARY;
RUN;

DATA CONTPLAN;
LENGTH START $8;
RETAIN FMTNAME '$CONTPLNF';
SET PLAN_FMT(RENAME=START=HPLAN DROP=FMTNAME);
START = SUBSTR(HPLAN,1,8);
RUN;

PROC SORT DATA=CONTPLAN NODUPKEY;
BY START;
RUN;

PROC FORMAT CNTLIN=CONTPLAN LIB=LIBRARY;
RUN;

DATA PBP_FILE;
SET &INPBP;
IF PUT(HPLAN,$TYPEF.) NE 'NO';
RUN;

PROC SORT DATA=PBP_FILE;
BY HPLAN;
RUN;

DATA MRX_FILE;
SET &INMRX;
IF PUT(HPLAN,$TYPEF.) NE 'NO';
RUN;

PROC DATASETS LIBRARY=WORK;
DELETE PBPPLANS MAPD MAON PDP MSA PLAN_FMT;
RUN;
