
* PROGRAM: COST_SHARING_RADIATION.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR RADIATION CLAIMS;

DATA RADIATION_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='8br'));
RUN;

data RADIATION_FILE;
    SET PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B8A_MAXENR_AMT PBP_B8A_MAXENR_PER
                   PBP_B8B_COPAY_AMT_TMC PBP_B8B_COINS_PCT_TMC PBP_B8A_DED_AMT);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from RADIATION_BASEID b, RADIATION_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO RADIATION_COST_SHARE(SERV_CAT);

%LET SERV_CAT = RADIATION;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B8A_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B8A_MAXENR_AMT;

    COST = .;
    COST = SUM(COST,(VISITS*PBP_B8B_COPAY_AMT_TMC));
    COST = SUM(COST,(AMTTOT*PBP_B8B_COINS_PCT_TMC));
    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "8br";
  RUN;

%MEND RADIATION_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=RADIATION;
RUN;

%RADIATION_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=RADIATION(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE RADIATION RADIATION_BASEID RADIATION_FILE CAT_JOIN;
QUIT;
RUN;
