* program:  C:\MPF\mpf2012\oopctool\model\input\FFS_BENEFIT_OOPC_COST_CALCULATION.sas;

* make changes for pde price run;

LIBNAME INPUT   "&INPUTDIR";

proc summary data=input.druglist_rxcui nway missing;
  class drugname drug_type;
  var awp_package_price;
  output out=druglist_type (drop=_type_ _freq_) median=;
run;

proc print data=druglist_type (obs=25);
  title 'druglist_type';
run;

data druglist_rollup;
set druglist_type;
by drugname;
array price(3) awp_brand awp_generic awp_unknown;
retain awp_brand awp_generic awp_unknown;
if first.drugname then do i = 1 to 3;
  price(i) = .;
end;
select(drug_type);
  when('B') price(1) = awp_package_price;
  when('G') price(2) = awp_package_price;
  when(' ') price(3) = awp_package_price;
  otherwise;
end;
if last.drugname;
keep drugname awp_brand awp_generic awp_unknown;
run;
 
proc sort data=input.bene_script out=bene_script_sort;
  by drugname;
run;

data bene_script;
  merge bene_script_sort (in=a) 
        druglist_rollup (in=b);
  by drugname;
  if a & b;
  if awp_generic^=. then awp_package_price=awp_generic;
  else if awp_brand^=. then awp_package_price=awp_brand;
  else awp_package_price=awp_unknown;
  if year=&YEAR1. then awp_package_price = awp_package_price * &DRUG_INF_YR1.;
  else if year=&YEAR2. then awp_package_price = awp_package_price * &DRUG_INF_YR2.;
run;

proc summary data=bene_script nway missing;
  class year baseid;
  var awp_package_price;
  output out=ffs_cost_calcs (drop=_type_ _freq_) sum=cost;
run;

%MACRO FFSDRUGS;
  data ffs_drugs;
    merge ffs_cost_calcs (in=a)
          &INP(in=b keep = baseid csyrwgt cell_group indmon year);
    by year baseid;
    if b;
    if not a then cost=0;
    monthly_cost=cost/indmon;
    if cell_group in ('1','2','3','4','5','6') then health = 1;
    else if cell_group in ('7','8','9','10','11','12') then health = 2; 
    else if cell_group in ('13','14','15','16','17','18') then health = 3;
    else if cell_group in ('19','20','21','22','23','24') then health = 4;
    else if cell_group in ('25','26','27','28','29','30') then health = 5;
 
    * added code for chronics;
    output;
     
    %IF &INPUT^=INPUTPLAN %THEN %DO;
      if year="&year1" then do;
        if put(baseid,$ahcy1f.)='yes' then do;
          cell_group='31';
          health=31;
          output;
        end;
        if put(baseid,$chfy1f.)='yes' then do;
          cell_group='32';
          health=32;
          output;
        end;
        if put(baseid,$diay1f.)='yes' then do;
          cell_group='33';
          health=33;
          output;
        end;
      end;
      else if year="&year2" then do;
        if put(baseid,$ahcy2f.)='yes' then do;
          cell_group='31';
          health=31;
          output;
        end;
        if put(baseid,$chfy2f.)='yes' then do;
          cell_group='32';
          health=32;
          output;
        end;
        if put(baseid,$diay2f.)='yes' then do;
          cell_group='33';
          health=33;
          output;
        end;
      end;
    %END;
  run;
%MEND;
RUN;

%FFSDRUGS;
RUN;

data ffs_drugs_nochron_yr1 ffs_drugs_nochron_yr2;
  set ffs_drugs;
  if year="&year1" & cell_group not in('31','32','33') then output ffs_drugs_nochron_yr1;
  else if year="&year2" & cell_group not in('31','32','33') then output ffs_drugs_nochron_yr2;
run;

data bdffs_fmt_yr1 (keep=start label hlo fmtname);
  set ffs_drugs_nochron_yr1 end=last;
  length fmtname $8 hlo $1;
  fmtname='$byr1ffs';
  start=baseid;
  label=monthly_cost;
  hlo=' ';
  output;
  if last then do;
    start=.;
    label=.;
    hlo='o';
    output;
  end;
run;

proc format cntlin=bdffs_fmt_yr1 library=library;
run;

data bdffs_fmt_yr2 (keep=start label hlo fmtname );
  set ffs_drugs_nochron_yr2 end=last;
  length fmtname $8 hlo $1;
  fmtname='$byr2ffs';
  start=baseid;
  label=monthly_cost;
  hlo=' ';
  output;
  if last then do;
    start=.;
    label=.;
    hlo='o';
    output;
  end;
run;

proc format cntlin=bdffs_fmt_yr2 library=library;
run;

proc summary data=ffs_drugs nway missing;
  where cell_group < '31';
  var monthly_cost;
  weight csyrwgt;
  output out=ffs_drugs_costs(drop=_type_ _freq_) mean=;
run;

proc print data=ffs_drugs_costs (obs=25);
  title 'ffs_drugs_cost';
run;

data _null_;
  set ffs_drugs_costs;
  call symput("ptdffs",left(put(monthly_cost,8.3)));
run;

proc summary data=ffs_drugs nway missing;
  class health;
  var monthly_cost;
  weight csyrwgt;
  output out=ffs_drugs_costs_cell(drop=_type_ _freq_) mean=;
run;

data dffs_fmt (keep=start label hlo fmtname type);
  set ffs_drugs_costs_cell end=last;
  length fmtname $8 hlo type $1;
  type='I';
  fmtname='ptdffsh';
  start=health;
  label=monthly_cost;
  hlo=' ';
  output;
  if last then do;
    start=.;
    label=.;
    hlo='o';
    output;
  end;
run;

proc format cntlin=dffs_fmt library=library;
run;

proc print data=ffs_drugs_costs_cell (obs=25);
  title 'ffs_drugs_cost_cell';
run;


