
* PLAN_CATNAME_NEW.SAS;
* DESCRIPTION: PERFORM FINAL CALCULATIONS AND CREATE FINAL SPREADSHEET;

LIBNAME LIBRARY "&INPUTDIR";

PROC FORMAT LIB=LIBRARY;
 VALUE $CATNAME
'1a'  ='Inpatient_Hospital_Acute_Care'
'1b'  ='Inpatient_Mental_Health_Care'
'2'   ='Skilled_Nursing_Facility'
'3p'  ='Pulmonary_Rehab_Services'
'3c'  ='Cardiac_Rehabilitation_Services'
'4a'  ='Emergency_Care'
'4b'  ='Urgently_Needed_Care'
'6'   ='Home_Health_Agency'
'7a'  ='Primary_Care_Physician'
'7b'  ='Chiropractic_Services'
'7c'  ='Occupational_Therapy'
'7d'  ='Physician_Specialists'
'7e'  ='Outpatient_Mental_Health_Care'
'7f'  ='Podiatry_Services'
'7g'  ='Other_Health_Professionals'
'7h'  ='Psychiatric_Care'
'7i'  ='Physical_and_Speech_Therapy'
'8al' ='Outpatient_Lab'
'8ad' ='Diagnostic_Tests_and_Procedures'
'8br' ='Therapeutic_Radiation'
'8bx' ='Outpatient_X_Rays'
'8bd' ='Diagnostic_Radiological_Services'
'9a'  ='Outpatient_Hospital_Services'
'9b'  ='Ambulatory_Surgical_Center'
'15c' ='Chemotherapy_Drugs'
'10a' ='Ambulance'
'11a' ='Durable_Medical_Equipment'
'11b' ='Prosthetic_Devices'
'12'  ='Renal_Dialysis'
'14d' ='Pap_Pelvic_Exams'
'14e' ='Diabetes_Education'
'14h' ='Screen_Mammography_Exams'
'15m' ='Medicare_Covered_Part_B_Drugs'
'16'  ='Preventative_Comp_Dental'
'16b' ='Medicare_Covered_Dental'
'17a' ='Eye_Exams'
'18a' ='Hearing_Exams'
'all' ='Total'
'DED' ='Plan_Deductible_Allocation'
 ;
 RUN;

%MACRO PLAN;

 DATA  BASEID_CATEGORY_ALLYEARS;
 SET

 %IF &PDP > 0 OR &MAPD > 0 %THEN %DO;
      BASEID_PLAN_CATEGORY_PARTD_&YEAR1(RENAME=CWGT=COMBO_WGT)
      BASEID_PLAN_CATEGORY_PARTD_&YEAR2(RENAME=CWGT=COMBO_WGT)
 %END;


 %IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 OR &FFS > 0 or &MGAP > 0 %THEN %DO;
      BASEID_PLAN_CATEGORY_COMP_&YEAR1(RENAME=CWGT=COMBO_WGT)
      BASEID_PLAN_CATEGORY_COMP_&YEAR2(RENAME=CWGT=COMBO_WGT)
 %END;
 ;
 BY CELL_GROUP HPLAN CATEGORY;
 
 OUTPUT;
 
 IF PUT(HPLAN,$TYPEF.)='MSA' & CATEGORY='ALL' THEN DO;
   CATEGORY='15';
   IF YEAR=&YEAR1. THEN DO;
     COST=PUT(BASEID,$BYR1FFS.);
     monthly_balance=msa_balance/indmon;
     if monthly_balance > 0 then MONTHLY_COST=MAX(0,COST-monthly_balance);
     else if monthly_balance <= 0 then MONTHLY_COST=COST;
     *MONTHLY_COST=MAX(0,COST-monthly_balance);
     *MONTHLY_COST=MAX(0,COST-(MSA_BALANCE/INDMON));
     if monthly_balance > 0 then b_flag = '1';
     else b_flag = '0';
     OUTPUT;
   END;
   ELSE IF YEAR=&YEAR2. THEN DO;
     COST=PUT(BASEID,$BYR2FFS.);
     monthly_balance=msa_balance/indmon;
     if monthly_balance > 0 then MONTHLY_COST=MAX(0,COST-monthly_balance);
     else if monthly_balance <= 0 then MONTHLY_COST=COST;
     *MONTHLY_COST=MAX(0,COST-monthly_balance);
     *MONTHLY_COST=MAX(0,COST-(MSA_BALANCE/INDMON));
     if monthly_balance > 0 then b_flag = '1';
     else b_flag = '0';
     OUTPUT;
   END;
 END;
 
 %IF &INPUT^=INPUTPLAN %THEN %DO;
   * ADDED CODE FOR CHRONICS;
   IF YEAR="&YEAR1" THEN DO;
     IF PUT(BASEID,$AHCY1F.)='yes' THEN DO;
       CELL_GROUP='31';
       OUTPUT;
     END;
     IF PUT(BASEID,$CHFY1F.)='yes' THEN DO;
       CELL_GROUP='32';
       OUTPUT;
     END;
     IF PUT(BASEID,$DIAY1F.)='yes' THEN DO;
       CELL_GROUP='33';
       OUTPUT;
     END;
   END;
   ELSE IF YEAR="&YEAR2" THEN DO;
     IF PUT(BASEID,$AHCY2F.)='yes' THEN DO;
       CELL_GROUP='31';
       OUTPUT;
     END;
     IF PUT(BASEID,$CHFY2F.)='yes' THEN DO;
       CELL_GROUP='32';
       OUTPUT;
     END;
     IF PUT(BASEID,$DIAY2F.)='yes' THEN DO;
       CELL_GROUP='33';
       OUTPUT;
     END;
   END;
 %END;
 RUN;

PROC SORT DATA=BASEID_CATEGORY_ALLYEARS;
BY CELL_GROUP HPLAN CATEGORY;
RUN;

DATA CCOHORT;
  SET &INP(KEEP=BASEID CSYRWGT YEAR CELL_GROUP);
  IF YEAR = "&YEAR1" THEN SOURCE = "&MCBSYR1";
  ELSE IF YEAR = "&YEAR2" THEN SOURCE = "&MCBSYR2";
     COMBO_WGT = CSYRWGT;
  OUTPUT;
  %IF &INPUT^=INPUTPLAN %THEN %DO;
    IF YEAR = "&YEAR1" THEN DO;
      IF PUT(BASEID,$AHCY1F.)='yes' THEN DO;
        CELL_GROUP='31';
        OUTPUT;
      END;
      IF PUT(BASEID,$CHFY1F.)='yes' THEN DO;
        CELL_GROUP='32';
        OUTPUT;
      END;
      IF PUT(BASEID,$DIAY1F.)='yes' THEN DO;
        CELL_GROUP='33';
        OUTPUT;
      END;
    END;
    ELSE IF YEAR = "&YEAR2" THEN DO;
      IF PUT(BASEID,$AHCY2F.)='yes' THEN DO;
        CELL_GROUP='31';
        OUTPUT;
      END;
      IF PUT(BASEID,$CHFY2F.)='yes' THEN DO;
        CELL_GROUP='32';
        OUTPUT;
      END;
      IF PUT(BASEID,$DIAY2F.)='yes' THEN DO;
        CELL_GROUP='33';
        OUTPUT;
      END;
    END;
  %END;
RUN;

/* DETAILED SAS VERSION FOR MOC */
PROC SUMMARY DATA = CCOHORT NWAY MISSING;
CLASS CELL_GROUP;
  VAR COMBO_WGT;
  OUTPUT OUT = COHORT_CELL_GROUP_DETAIL(DROP=_FREQ_ _TYPE_) SUM = COMBOWGT_SUM;
RUN;

PROC MEANS DATA = BASEID_CATEGORY_ALLYEARS NOPRINT NWAY;
  CLASS CELL_GROUP HPLAN CATEGORY;
  WEIGHT COMBO_WGT;
  VAR MONTHLY_COST;
  OUTPUT OUT = PLAN_DETAIL SUM = MONTHLY_COST_SUM;
RUN;

DATA PLAN_COSTS_DETAIL;
  MERGE PLAN_DETAIL (IN=A)
        COHORT_CELL_GROUP_DETAIL (IN=B);
  BY CELL_GROUP;
  IF A & B;
  MONTHLY_COST_MEAN = MONTHLY_COST_SUM / COMBOWGT_SUM;
RUN;

DATA PLAN_COSTS_DETAIL_CAT(DROP=_TYPE_ _FREQ_);
LENGTH CATNAME $50;
SET PLAN_COSTS_DETAIL (WHERE=(_TYPE_ ^=0 AND HPLAN ^=:' ' AND CATEGORY ^= '   '));
CATNAME = PUT(CATEGORY,$CATNAME.);
RUN;

%IF &INPUT^=INPUTPLAN %THEN %DO;
  DATA OUT.OOPC_PLAN_DETAIL;
  SET PLAN_COSTS_DETAIL_CAT; 
  RUN;
%END;

/* END OF DETAILED SAS VERSION FOR MOC */

PROC SUMMARY DATA = CCOHORT NWAY MISSING;
  WHERE CELL_GROUP <= '30';
  VAR COMBO_WGT;
  OUTPUT OUT = COHORT_CELL_GROUP(DROP=_FREQ_ _TYPE_) SUM = COMBOWGT_SUM;
RUN;

PROC MEANS DATA =  BASEID_CATEGORY_ALLYEARS NOPRINT;
  CLASS HPLAN CATEGORY;
  WEIGHT COMBO_WGT;
  VAR MONTHLY_COST;
  WHERE CELL_GROUP <= '30';
  OUTPUT OUT = PLAN SUM = MONTHLY_COST_SUM;
RUN;

DATA PLAN_COSTS;
  IF _N_ = 1 THEN SET COHORT_CELL_GROUP(KEEP = COMBOWGT_SUM);
  SET PLAN(IN = A);
  MONTHLY_COST_MEAN      = MONTHLY_COST_SUM / COMBOWGT_SUM;
  RUN;

PROC SORT DATA=PLAN_COSTS OUT= PLAN_COSTS;
BY HPLAN;
RUN;

DATA SECTION_A(RENAME=(PBP_A_ORG_TYPE=ORG_TYPE
                       PBP_A_PLAN_TYPE=PLAN_TYPE PBP_A_ORG_MARKETING_NAME=MARKETING_NAME
                       PBP_A_ORG_NAME=ORG_NAME PBP_A_Plan_Name=Plan_Name));
LENGTH TYPE $4;
  SET  PBP_FILE;
  TYPE = PUT(HPLAN,$TYPEF.);
  IF TYPE NE 'NO';
RUN;

DATA PLAN_COSTS_CAT(DROP=_TYPE_ _FREQ_  COMBOWGT_SUM);
LENGTH CATNAME $ 50;
SET  PLAN_COSTS(WHERE=(_TYPE_ ^=0 AND HPLAN ^=:' ' AND CATEGORY ^= '   '));
CATNAME = PUT(CATEGORY,$CATNAME.);
RUN;

DATA PLAN_CATS(KEEP=HPLAN CATNAME CATEGORY MONTHLY_COST_MEAN);
 SET  PLAN_COSTS_CAT;
RUN;

PROC TRANSPOSE DATA=PLAN_CATS(DROP=CATEGORY) OUT=PARTC_PLANS(DROP=_NAME_);
VAR MONTHLY_COST_MEAN;
ID CATNAME;
BY HPLAN;
RUN;

PROC SORT;
BY HPLAN;
RUN;

DATA PARTC_PLANS_ALL;
SET
    %IF &MAPD > 0 OR &MAON > 0 OR &FFS > 0 OR &MGAP > 0 OR &MSA > 0 %THEN %DO;
    PARTC_PLANS
    %END;
;
BY HPLAN;
RUN;

PROC SORT DATA=PARTC_PLANS_ALL;
BY HPLAN;
RUN;

DATA PARTC_PLANS
%IF &MAPD > 0 OR &PDP > 0 %THEN %DO;
(DROP=_15)
%END;
;
%IF &MAON = 0 AND &MAPD = 0 AND &PDP > 0 %THEN %DO;
RETAIN
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams 
 Plan_Deductible_Allocation .;

%END;
 SET PARTC_PLANS_ALL;
%IF &MAON = 0 AND &MAPD = 0 AND &PDP > 0 %THEN %DO;
 ALL = .;
%END;
%IF &MAPD > 0 OR &PDP > 0 %THEN %DO;
 PartD = _15;
%END;
RUN;

DATA PARTC_PLANS_CD(DROP=MARKETING_NAME TYPE);
LENGTH HPLAN $11
       CONTRACT_ID $5
       Plan_ID $3
       Segment_ID $3
       ORG_MKT_NAME $ 50
       Plan_Name    $ 75
       YEAR         $4
       PARTD 8;
ARRAY ACAT(38) 
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
 Plan_Deductible_Allocation;

 MERGE PARTC_PLANS(IN=A)
       SECTION_A(IN=C KEEP=PLAN_TYPE TYPE HPLAN CONTRACT_ID Plan_ID MARKETING_NAME Plan_Name Segment_ID);
BY HPLAN;
IF TYPE IN('MAON','FFS','MGAP') THEN PartD=&ptdffs.;
IF TOTAL = . THEN TOTAL = ALL;
Grand_Total = SUM(TOTAL,PartD);
YEAR = "&RUNYEAR";
ORG_MKT_NAME  = MARKETING_NAME;
IF TOTAL = . THEN TOTAL = ALL;
IF TYPE = 'PDP' THEN DO;
   DO I = 1 TO DIM(ACAT);
      ACAT(I) = .;
   END;
   TOTAL = .;
   Grand_Total = SUM(TOTAL,PartD);
   * DELETE PDP EMPLOYER PLANS THAT WILL NOT HAVE ANY RESULTS;
   IF Plan_ID =: '8' THEN DELETE;
END;
*KEEP ONLY PLANS BEING RUN;
IF PUT(HPLAN,$TYPEF.) NE 'NO';
RUN;

PROC SORT DATA=PARTC_PLANS_CD OUT=PARTC_PLANS_CD;
BY HPLAN;
RUN;

DATA  OOPCS_ALL_FINAL_CD(RENAME=(CONTRACT_ID=Contract_Number
ORG_MKT_NAME=Organization_Marketing_Name YEAR=Benefit_Year));
LENGTH CONTRACT_ID $5 Plan_ID $3 Segment_ID $3 ORG_MKT_NAME $50 Plan_Name $75 YEAR $4 
 %IF &INPUT^=INPUTPLAN %THEN %DO;
   Formulary_Version 8
 %END;
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
 Plan_Deductible_Allocation
 Total
 PartD
 Grand_Total 8
 PBP_Version_Date $21;
SET PARTC_PLANS_CD(KEEP=CONTRACT_ID Plan_ID Segment_ID ORG_MKT_NAME Plan_Name YEAR 
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
 Plan_Deductible_Allocation
 Total
 PartD
 Grand_Total
 HPLAN);
%IF &INPUT^=INPUTPLAN %THEN %DO;
  Formulary_Version=PUT(CONTRACT_ID||PLAN_ID,$CONTVER.);
%END;
PBP_Version_Date=left(put(&VERSION_DATE.,datetime21.));
Segment_ID=put(input(Segment_ID,8.),z3.);
RUN;

PROC PRINT DATA=OOPCS_ALL_FINAL_CD (OBS=10);
TITLE'CHECK';
RUN;
  
DATA OOPCS_ALL_FINAL_CD_WO_MGAPFFS (DROP=HPLAN) OOPCS_ALL_FINAL_CD_MGAPFFS (DROP=HPLAN);
SET OOPCS_ALL_FINAL_CD;
IF PUT(HPLAN,$TYPEF.) IN('MGAP','FFS') THEN OUTPUT OOPCS_ALL_FINAL_CD_MGAPFFS;
ELSE OUTPUT OOPCS_ALL_FINAL_CD_WO_MGAPFFS;
RUN;

%IF &INPUT^=INPUTPLAN %THEN %DO;
  PROC EXPORT DATA=OOPCS_ALL_FINAL_CD_MGAPFFS
              OUTFILE= "&OOPC_W_MGAPFFS"
              DBMS=EXCEL REPLACE;
       SHEET="OOPCS &RUNYEAR";
  RUN;
%END;

PROC EXPORT DATA=OOPCS_ALL_FINAL_CD_WO_MGAPFFS 
            OUTFILE= "&OOPC"
            DBMS=EXCEL REPLACE;
     SHEET="OOPCS &RUNYEAR";
RUN;

%MEND;
RUN;

%PLAN;
RUN;
